/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.processes.threading;

import de.halcony.processes.threading.ThreadManager;
import scala.Function1;
import scala.Function2;
import scala.runtime.BoxedUnit;

public class ThreadManagerBuilder<T> {
    private final ThreadManager<T> threadManager;

    public ThreadManagerBuilder(Function1<T, BoxedUnit> lambda) {
        this.processingLambda(lambda);
        this.threadManager = new ThreadManager();
    }

    private ThreadManagerBuilder<T> processingLambda(Function1<T, BoxedUnit> lambda) {
        this.threadManager.setLambda(lambda);
        return this;
    }

    public ThreadManagerBuilder<T> threadCount(int count) {
        this.threadManager.setThreadCount(count);
        return this;
    }

    public ThreadManagerBuilder<T> handleErrors(Function2 onError) {
        this.threadManager.setOnError(onError);
        return this;
    }

    public ThreadManager<T> create() {
        return this.threadManager.createPool();
    }

    public ThreadManager<T> start() {
        return this.create().start();
    }
}

