/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.processes.cmd;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public class CmdProcess
implements LoggingMethods,
LazyLogger,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CmdProcess.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private Option<Process> wrappedProcess;
    private boolean shallBeAlive;
    private Option<scala.collection.mutable.StringBuilder> stdoutCollector;
    private Option<Thread> stdoutCollectorThread;
    private Option<Exception> stdoutCollectorError;
    private Option<scala.collection.mutable.StringBuilder> stderrCollector;
    private Option<Thread> stderrCollectorThread;
    private Option<Exception> stderrCollectorError;

    public CmdProcess() {
        this.logger().setLogLevel((LogLevel)LogLevel.ERROR$.MODULE$);
        this.wrappedProcess = None$.MODULE$;
        this.shallBeAlive = true;
        this.stdoutCollector = None$.MODULE$;
        this.stdoutCollectorThread = None$.MODULE$;
        this.stdoutCollectorError = None$.MODULE$;
        this.stderrCollector = None$.MODULE$;
        this.stderrCollectorThread = None$.MODULE$;
        this.stderrCollectorError = None$.MODULE$;
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Process getProcess() {
        Option<Process> option = this.wrappedProcess;
        if (option instanceof Some) {
            Process process = (Process)((Some)option).value();
            return process;
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("process has never been started");
        }
        throw new MatchError(option);
    }

    private boolean getShallBeAlive() {
        boolean bl;
        CmdProcess cmdProcess = this;
        synchronized (cmdProcess) {
            bl = this.shallBeAlive;
        }
        return bl;
    }

    private boolean setShallBeAlive(boolean value) {
        boolean bl;
        CmdProcess cmdProcess = this;
        synchronized (cmdProcess) {
            bl = this.shallBeAlive = value;
        }
        return bl;
    }

    private Thread createStreamReaderThread(InputStream inputStream, scala.collection.mutable.StringBuilder collector, boolean errorStream) {
        Logger parentLogger = this.logger();
        return new Thread(() -> {
            block9: {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                    CharBuffer buffer = CharBuffer.allocate(1000);
                    while ((reader.ready() || this.isAlive()) && this.getShallBeAlive()) {
                        reader.read(buffer);
                        collector.append((CharSequence)buffer);
                        buffer.clear();
                        if (reader.ready()) continue;
                        reader.wait(100L);
                    }
                }
                catch (Exception e) {
                    if (errorStream) {
                        Logger LoggerBase_this = parentLogger;
                        if (LoggerBase_this.isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                            LoggerBase_this.logWithCause((LogLevel)LogLevel.ERROR$.MODULE$, LogSource$.MODULE$.apply("", "CmdProcess.scala", 57, 64), (Object)new StringBuilder(13).append("[ErrorStream]").append(e.getMessage()).toString(), (Throwable)e);
                        }
                        this.stderrCollectorError = Some$.MODULE$.apply((Object)e);
                        break block9;
                    }
                    Logger LoggerBase_this = parentLogger;
                    if (LoggerBase_this.isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                        LoggerBase_this.logWithCause((LogLevel)LogLevel.ERROR$.MODULE$, LogSource$.MODULE$.apply("", "CmdProcess.scala", 60, 65), (Object)new StringBuilder(14).append("[StdoutStream]").append(e.getMessage()).toString(), (Throwable)e);
                    }
                    this.stdoutCollectorError = Some$.MODULE$.apply((Object)e);
                }
            }
        });
    }

    public CmdProcess setStdoutCollector(scala.collection.mutable.StringBuilder collector) {
        this.stdoutCollector = Some$.MODULE$.apply((Object)collector);
        return this;
    }

    public CmdProcess setStderrCollector(scala.collection.mutable.StringBuilder collector) {
        this.stderrCollector = Some$.MODULE$.apply((Object)collector);
        return this;
    }

    public CmdProcess start(Process process) {
        this.wrappedProcess = Some$.MODULE$.apply((Object)process);
        this.stdoutCollector.foreach((Function1)(JProcedure1 & Serializable)collector -> {
            this.stdoutCollectorThread = Some$.MODULE$.apply((Object)this.createStreamReaderThread(process.getInputStream(), (scala.collection.mutable.StringBuilder)collector, false));
            ((Thread)this.stdoutCollectorThread.get()).start();
        });
        this.stderrCollector.foreach((Function1)(JProcedure1 & Serializable)collector -> {
            this.stderrCollectorThread = Some$.MODULE$.apply((Object)this.createStreamReaderThread(process.getErrorStream(), (scala.collection.mutable.StringBuilder)collector, false));
            ((Thread)this.stderrCollectorThread.get()).start();
        });
        return this;
    }

    public CmdProcess setLogLevel(LogLevel level) {
        this.logger().setLogLevel(level);
        return this;
    }

    public Process getWrappedProcess() {
        return this.getProcess();
    }

    public boolean isAlive() {
        return this.getProcess().isAlive();
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        return this.getProcess().waitFor(timeout, unit);
    }

    public <T> T waitFor(long timeout, TimeUnit unit, Function0<T> onSuccess, Function0<T> onFailure) {
        this.waitFor(timeout, unit);
        if (this.isAlive()) {
            return (T)onSuccess.apply();
        }
        return (T)onFailure.apply();
    }

    public void destroy() {
        this.setShallBeAlive(false);
        this.getProcess().destroy();
    }

    public void destroyOrElse(Function0<BoxedUnit> orElse) {
        this.destroyOrElse(100L, TimeUnit.MILLISECONDS, orElse);
    }

    public void destroyOrElse(long gracePeriod, TimeUnit unit, Function0<BoxedUnit> orElse) {
        this.destroy();
        this.waitFor(gracePeriod, unit);
        if (this.isAlive()) {
            orElse.apply$mcV$sp();
            return;
        }
    }

    public String getStdout() {
        Option<scala.collection.mutable.StringBuilder> option = this.stdoutCollector;
        if (option instanceof Some) {
            scala.collection.mutable.StringBuilder collector = (scala.collection.mutable.StringBuilder)((Some)option).value();
            return collector.toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("no in-process stdout collection configured");
        }
        throw new MatchError(option);
    }

    public String getStdErr() {
        Option<scala.collection.mutable.StringBuilder> option = this.stderrCollector;
        if (option instanceof Some) {
            scala.collection.mutable.StringBuilder collector = (scala.collection.mutable.StringBuilder)((Some)option).value();
            return collector.toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("no in-process stderr collection configured");
        }
        throw new MatchError(option);
    }

    public void destroyForcibly() {
        this.setShallBeAlive(false);
        this.getProcess().destroyForcibly();
    }

    public int getExitValue() {
        return this.getProcess().exitValue();
    }
}

