/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica.reader.model;

import de.gwdg.metadataqa.marc.utils.pica.PicaSubfield;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PicaLine {
    private static final Logger logger = Logger.getLogger(PicaLine.class.getCanonicalName());
    private static final Pattern LINE = Pattern.compile("^(SET:|Eingabe:|Warnung:|[0-2]\\d\\d[A-Z@])(\\/(\\d\\d+))? ((\\u0085|.)*+)$", 8);
    private static Map<String, String> quotedSeparatorMap = new HashMap<String, String>();
    public static final String DEFAULT_SEPARATOR = "$";
    private static final String SET = "SET";
    private static final String EINGABE = "Eingabe";
    private static final String WARNUNG = "Warnung";
    private String subfieldSeparator = "$";
    private String quotedSubfieldSeparator = PicaLine.getQuotedSeparator(this.subfieldSeparator);
    private static String DOLLAR_REPLACEMENT = "%26%26";
    private String tag;
    private String occurrence;
    private String content;
    private List<PicaSubfield> subfields;
    private boolean valid = false;
    private boolean skippable = false;

    public PicaLine() {
    }

    public PicaLine(String raw) {
        this.parse(raw);
    }

    public PicaLine(String raw, String subfieldSeparator) {
        this.subfieldSeparator = subfieldSeparator;
        this.quotedSubfieldSeparator = PicaLine.getQuotedSeparator(subfieldSeparator);
        this.parse(raw);
    }

    private static String getQuotedSeparator(String separator) {
        if (!quotedSeparatorMap.containsKey(separator)) {
            quotedSeparatorMap.put(separator, Pattern.quote(separator));
        }
        return quotedSeparatorMap.get(separator);
    }

    public boolean isSET() {
        return this.tag.equals(SET);
    }

    public boolean isEingabe() {
        return this.tag.equals(EINGABE);
    }

    public boolean isWarnung() {
        return this.tag.equals(WARNUNG);
    }

    public boolean isValidTag() {
        return this.valid && !this.isSET() && !this.isEingabe() && !this.isWarnung();
    }

    public String getTag() {
        return this.tag;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public List<PicaSubfield> getSubfields() {
        return this.subfields;
    }

    public String getQualifiedTag() {
        if (this.occurrence != null) {
            return this.tag + "/" + this.occurrence;
        }
        return this.tag;
    }

    public String formatSubfields() {
        if (this.subfields == null) {
            logger.severe("null subfields: " + this.content);
            return "";
        }
        ArrayList<String> formattedSubfields = new ArrayList<String>();
        for (PicaSubfield subfield : this.subfields) {
            formattedSubfields.add(subfield.format());
        }
        return StringUtils.join(formattedSubfields, (String)", ");
    }

    public String getContent() {
        return this.content;
    }

    private void parse(String raw) {
        if (raw.equals("")) {
            this.skippable = true;
        } else {
            Matcher matcher = LINE.matcher(raw);
            if (matcher.matches()) {
                this.tag = matcher.group(1).replaceAll(":$", "");
                this.occurrence = matcher.group(3);
                this.content = matcher.group(4);
                this.parseSubfields();
                this.valid = true;
            } else {
                logger.log(Level.WARNING, "Unable to parse line: \"{0}\"", raw);
            }
        }
    }

    private void parseSubfields() {
        this.subfields = new ArrayList<PicaSubfield>();
        boolean dollarReplacement = false;
        String[] parts = null;
        if (this.subfieldSeparator.equals(DEFAULT_SEPARATOR) && this.content.contains("$$")) {
            dollarReplacement = true;
            parts = this.content.replace("$$", DOLLAR_REPLACEMENT).split(this.quotedSubfieldSeparator);
        } else {
            parts = this.content.split(this.quotedSubfieldSeparator);
        }
        for (String part : parts) {
            if (!StringUtils.isNotBlank((CharSequence)part)) continue;
            if (dollarReplacement) {
                part = part.replace(DOLLAR_REPLACEMENT, DEFAULT_SEPARATOR);
            }
            this.subfields.add(new PicaSubfield(part.substring(0, 1), part.substring(1)));
        }
    }

    public String toString() {
        return "PicaLine{tag='" + this.tag + "', occurrence='" + this.occurrence + "', subfields=" + this.subfields + "}";
    }

    public boolean isSkippable() {
        return this.skippable || this.isSET() || this.isEingabe() || this.isWarnung();
    }
}

