/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica.organisation;

import de.gwdg.metadataqa.marc.utils.pica.organisation.K10Organisation;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public class K10OrganisationReader {
    private static final Logger logger = Logger.getLogger(K10OrganisationReader.class.getCanonicalName());

    public static Map<String, K10Organisation> fileToCodeList(String fileName) {
        boolean isTsv = fileName.endsWith(".tsv");
        HashMap<String, K10Organisation> codes = new HashMap<String, K10Organisation>();
        try {
            LineIterator it = K10OrganisationReader.getLineIterator(fileName);
            while (it.hasNext()) {
                String id;
                String[] parts;
                String line = it.nextLine();
                if (line.equals("") || line.startsWith("#") || line.startsWith("--")) continue;
                if (isTsv) {
                    parts = line.split("\t", 3);
                    if (parts.length <= 1) continue;
                    id = K10OrganisationReader.removeLeadingZeros(parts[0]);
                    codes.put(id, new K10Organisation(id, parts[1], parts[2]));
                    continue;
                }
                parts = line.split(": ", 2);
                if (parts.length <= 1) continue;
                id = K10OrganisationReader.removeLeadingZeros(parts[0]);
                codes.put(id, new K10Organisation(id, id, parts[1]));
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "fileToCodeList", e);
        }
        return codes;
    }

    private static String removeLeadingZeros(String id) {
        return id.replaceAll("^0+", "");
    }

    private static LineIterator getLineIterator(String fileName) throws IOException {
        return IOUtils.lineIterator((InputStream)new FileInputStream(fileName), (Charset)StandardCharsets.UTF_8);
    }
}

