/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VocabularyPattern {
    private List<String> codes = new ArrayList<String>();
    private Pattern pattern;

    public VocabularyPattern(String codes, String pattern) {
        this.codes = this.transform(codes);
        this.pattern = Pattern.compile(pattern);
    }

    private List<String> transform(String _codes) {
        ArrayList<String> codes = new ArrayList<String>();
        if (_codes.length() == 1) {
            codes.add(_codes);
        } else if (_codes.startsWith("[") && _codes.endsWith("]")) {
            for (int i = 1; i < _codes.length() - 1; ++i) {
                codes.add(_codes.substring(i, i + 1));
            }
        }
        return codes;
    }

    public boolean fitsSubfield(String code) {
        return this.codes.contains(code);
    }

    public String extract(String s) {
        Matcher matcher = this.pattern.matcher(s);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String toString() {
        return "VocabularyPattern{codes=" + this.codes + ", pattern=" + this.pattern + "}";
    }

    public List<String> getCodes() {
        return this.codes;
    }
}

