/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.utils.pica.OccurrenceRange;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PicaplusTag {
    private static final Logger logger = Logger.getLogger(PicaplusTag.class.getCanonicalName());
    private static final Pattern rangePattern = Pattern.compile("^(\\d+)-(\\d+)$");
    private static final Pattern xPattern = Pattern.compile("^(\\d)X$");
    private static final Pattern numericPattern = Pattern.compile("^(\\d+)$");
    private String raw;
    private String tag;
    private String basetag;
    private String occurrence = null;
    private OccurrenceRange occurrenceRange = null;

    public PicaplusTag(String tag) {
        this.raw = tag;
        this.parse(tag);
    }

    public boolean hasOccurrence() {
        return this.occurrence != null;
    }

    public boolean hasOccurrenceRange() {
        return this.occurrenceRange != null;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getTag() {
        return this.tag;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public OccurrenceRange getOccurrenceRage() {
        return this.occurrenceRange;
    }

    public String getBasetag() {
        return this.basetag;
    }

    private void parse(String picaplus) {
        if (!picaplus.contains("/")) {
            this.tag = picaplus;
        } else {
            this.tag = picaplus;
            String[] parts = picaplus.split("/");
            this.basetag = parts[0];
            this.occurrence = parts[1];
            if (this.occurrence.contains("-")) {
                this.parseRangePattern();
            } else if (this.occurrence.endsWith("X")) {
                this.parseXpattern();
            } else if (!numericPattern.matcher(this.occurrence).find()) {
                logger.severe("Error in picaplus: " + picaplus + ". Does not fit to the numeric pattern.");
            }
        }
    }

    private void parseRangePattern() {
        Matcher matcher = rangePattern.matcher(this.occurrence);
        if (matcher.find()) {
            String start = matcher.group(1);
            String end = matcher.group(2);
            if (start.length() == end.length()) {
                this.occurrenceRange = new OccurrenceRange(start.length(), Integer.parseInt(start), Integer.parseInt(end));
            } else {
                logger.severe("Error in picaplus: " + this.raw + ". Length of start and end are different.");
            }
        } else {
            logger.log(Level.SEVERE, "Error in picaplus: {0} (raw: {1}). Does not fit to the range pattern.", new Object[]{this.occurrence, this.raw});
        }
    }

    private void parseXpattern() {
        Matcher matcher = xPattern.matcher(this.occurrence);
        if (matcher.find()) {
            String base = matcher.group(1);
            this.occurrenceRange = new OccurrenceRange(2, Integer.parseInt(base + "0"), Integer.parseInt(base + "9"));
        } else {
            logger.severe("Error in picaplus: " + this.raw + ". Does not fit to the [0-9]X pattern.");
        }
    }
}

