/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.utils.pica.PicaFieldDefinition;
import de.gwdg.metadataqa.marc.utils.pica.PicaSchemaManager;
import de.gwdg.metadataqa.marc.utils.pica.PicaTagDefinition;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.commons.lang3.StringUtils;

public class PicaSchemaReader {
    private static final Logger logger = Logger.getLogger(PicaSchemaReader.class.getCanonicalName());
    private JSONParser parser = new JSONParser(656);
    private Map<String, PicaFieldDefinition> map = new HashMap<String, PicaFieldDefinition>();
    private PicaSchemaManager schema = new PicaSchemaManager();

    private PicaSchemaReader(String fileName) {
        try {
            this.readFile(fileName);
        }
        catch (IOException | URISyntaxException | ParseException e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    private PicaSchemaReader(InputStream inputStream) {
        try {
            this.readStream(inputStream);
        }
        catch (IOException | URISyntaxException | ParseException e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    public static Map<String, PicaFieldDefinition> create(String filename) {
        PicaSchemaReader reader = new PicaSchemaReader(filename);
        return reader.map;
    }

    public static PicaSchemaManager createSchema(String filename) {
        PicaSchemaReader reader = new PicaSchemaReader(filename);
        return reader.getSchema();
    }

    public static PicaSchemaManager createSchema(InputStream inputStream) {
        PicaSchemaReader reader = new PicaSchemaReader(inputStream);
        return reader.getSchema();
    }

    public static PicaSchemaManager createSchemaManager(String picaSchemaFile) {
        PicaSchemaManager picaSchemaManager;
        logger.info("read schema");
        String schemaFile = null;
        if (StringUtils.isNotEmpty((CharSequence)picaSchemaFile)) {
            logger.info("getPicaSchemaFile");
            schemaFile = picaSchemaFile;
        } else if (new File("src/main/resources/pica/avram-k10plus-title.json").exists()) {
            logger.info("default file");
            schemaFile = Paths.get("src/main/resources/pica/avram-k10plus-title.json", new String[0]).toAbsolutePath().toString();
        }
        if (schemaFile != null && new File(schemaFile).exists()) {
            logger.info("read from file: " + schemaFile);
            picaSchemaManager = PicaSchemaReader.createSchema(schemaFile);
        } else {
            logger.info("read from resource");
            picaSchemaManager = PicaSchemaReader.createSchema(PicaSchemaReader.class.getClassLoader().getResourceAsStream("pica/avram-k10plus-title.json"));
        }
        return picaSchemaManager;
    }

    private void readFile(String fileName) throws IOException, ParseException, URISyntaxException {
        JSONObject obj = (JSONObject)this.parser.parse((Reader)new FileReader(fileName));
        this.process(obj);
    }

    private void readStream(InputStream inputStream) throws IOException, ParseException, URISyntaxException {
        JSONObject obj = (JSONObject)this.parser.parse((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        this.process(obj);
    }

    private void process(JSONObject obj) throws IOException, ParseException, URISyntaxException {
        JSONObject jsonObject = obj;
        JSONObject fields = (JSONObject)jsonObject.get((Object)"fields");
        for (Map.Entry entry : fields.entrySet()) {
            String id = (String)entry.getKey();
            JSONObject field = (JSONObject)entry.getValue();
            PicaTagDefinition tag = new PicaTagDefinition((String)field.get((Object)"pica3"), (String)field.get((Object)"tag"), (Boolean)field.get((Object)"repeatable"), false, (String)field.get((Object)"label"));
            tag.setId(id);
            tag.setDescriptionUrl((String)field.get((Object)"url"));
            tag.setModified((String)field.get((Object)"modified"));
            tag.setOccurrence((String)field.get((Object)"occurrence"));
            tag.setCounter((String)field.get((Object)"counter"));
            if (tag.getCounter() != null && tag.getOccurrence() != null) {
                logger.info(id + " has both counter and occurrence");
            }
            this.processSubfields(field, tag);
            PicaFieldDefinition definition = new PicaFieldDefinition(tag);
            this.addTag(definition);
            if (!id.endsWith("/00")) continue;
            PicaFieldDefinition definition2 = definition.copyWithChangesId();
            this.addTag(definition2);
        }
    }

    private void processSubfields(JSONObject field, PicaTagDefinition tag) {
        Object subfieldsRaw = field.get((Object)"subfields");
        LinkedList<SubfieldDefinition> subfieldDefinitions = new LinkedList<SubfieldDefinition>();
        if (subfieldsRaw != null) {
            if (subfieldsRaw instanceof JSONObject) {
                JSONObject subfields = (JSONObject)subfieldsRaw;
                for (Map.Entry entry : subfields.entrySet()) {
                    this.processSubfield(entry.getValue(), subfieldDefinitions);
                }
            } else if (subfieldsRaw instanceof JSONArray) {
                JSONArray subfields = (JSONArray)subfieldsRaw;
                for (int i = 0; i < subfields.size(); ++i) {
                    this.processSubfield(subfields.get(i), subfieldDefinitions);
                }
            }
        }
        tag.setSubfields(subfieldDefinitions);
    }

    private void processSubfield(Object o, List<SubfieldDefinition> subfieldDefinitions) {
        SubfieldDefinition definition = this.extractSubfield(o);
        if (definition != null) {
            subfieldDefinitions.add(definition);
        }
    }

    private SubfieldDefinition extractSubfield(Object o) {
        SubfieldDefinition definition = null;
        if (o instanceof JSONObject) {
            JSONObject subfield = (JSONObject)o;
            String code = (String)subfield.get((Object)"code");
            String label = (String)subfield.get((Object)"label");
            String cardinalityCode = (Boolean)subfield.get((Object)"repeatable") != false ? Cardinality.Repeatable.getCode() : Cardinality.Nonrepeatable.getCode();
            definition = new SubfieldDefinition(code, label, cardinalityCode);
            for (String key : subfield.keySet()) {
                if (key.equals("code") || key.equals("label") || key.equals("repeatable") || key.equals("modified") || key.equals("order") || key.equals("pica3")) continue;
                logger.warning("unhandled key in subfield: " + key);
            }
        } else {
            logger.warning("the JSON node's type is not JSONObject, but " + o.getClass().getCanonicalName());
        }
        return definition;
    }

    private void addTag(PicaFieldDefinition definition) {
        this.schema.add(definition);
    }

    public Map<String, PicaFieldDefinition> getMap() {
        return this.map;
    }

    public PicaSchemaManager getSchema() {
        return this.schema;
    }
}

