/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.parser;

import de.gwdg.metadataqa.marc.utils.parser.BooleanContainer;
import java.util.Deque;
import java.util.LinkedList;

public class BooleanParser {
    String token = "";
    String last = "";
    int start = 0;
    boolean skippedOp = false;
    String input;
    Deque<Integer> parens = new LinkedList<Integer>();

    private BooleanParser(String input) {
        this.input = input;
    }

    public static BooleanContainer<String> parse(String input) {
        BooleanParser parser = new BooleanParser(input);
        return parser.parse();
    }

    private BooleanContainer<String> parse() {
        BooleanContainer<String> root = new BooleanContainer<String>();
        for (int i = 0; i < this.input.length(); ++i) {
            String n = this.input.substring(i, i + 1);
            if (n.equals("&") && this.last.equals("&")) {
                this.processOp(i, root, BooleanContainer.Op.AND);
            } else if (n.equals("|") && this.last.equals("|")) {
                this.processOp(i, root, BooleanContainer.Op.OR);
            } else if (n.equals("(")) {
                this.parens.add(i);
            } else if (n.equals(")")) {
                if (this.parens.isEmpty()) {
                    throw new IllegalArgumentException("Error: closing parens without opening one: " + this.input);
                }
                this.parens.pollLast();
            }
            this.last = n;
        }
        this.token = this.input.substring(this.start).trim();
        this.addChild(root, this.token);
        if (!this.parens.isEmpty()) {
            throw new IllegalArgumentException("Error: opening parens without closing one: " + this.input);
        }
        return root;
    }

    private void processOp(int i, BooleanContainer<String> root, BooleanContainer.Op and) {
        if (this.parens.isEmpty()) {
            if (root.getOp() == null) {
                root.setOp(and);
            }
            this.addChild(root, this.input.substring(this.start, i - 1).trim());
            this.start = i + 1;
            this.skippedOp = false;
        } else {
            this.skippedOp = true;
        }
    }

    private void addChild(BooleanContainer<String> root, String token) {
        BooleanContainer<String> child;
        if (!(!this.skippedOp || token.startsWith("(") && token.endsWith(")"))) {
            throw new IllegalArgumentException("internal operator with imperfect parenthes: " + this.input);
        }
        BooleanContainer<String> booleanContainer = child = token.startsWith("(") && token.endsWith(")") ? BooleanParser.parse(token.substring(1, token.length() - 1)) : new BooleanContainer<String>(token);
        if (child.getValue() != null && child.getOp() == null && root.getOp() == null) {
            root.setValue(child.getValue());
        } else {
            root.getChildren().add(child);
        }
    }
}

