/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.parser;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BooleanContainer<T> {
    private Op op;
    private List<BooleanContainer<T>> children = new ArrayList<BooleanContainer<T>>();
    private T value;

    public BooleanContainer() {
    }

    public BooleanContainer(T value) {
        this.value = value;
    }

    public BooleanContainer(Op op, List<BooleanContainer<T>> children) {
        this.op = op;
        this.children = children;
    }

    public Op getOp() {
        return this.op;
    }

    public boolean hasAnd() {
        return this.op.equals((Object)Op.AND);
    }

    public boolean hasOr() {
        return this.op.equals((Object)Op.OR);
    }

    public void setOp(Op op) {
        this.op = op;
    }

    public List<BooleanContainer<T>> getChildren() {
        return this.children;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public int size() {
        int size = 0;
        if (this.value != null) {
            ++size;
        }
        if (this.children != null) {
            for (BooleanContainer<T> child : this.children) {
                size += child.size();
            }
        }
        return size;
    }

    public String toString() {
        ArrayList<CallSite> props = new ArrayList<CallSite>();
        if (this.op != null) {
            props.add((CallSite)((Object)("op=" + this.op)));
        }
        if (!this.children.isEmpty()) {
            props.add((CallSite)((Object)("children=" + this.children)));
        }
        if (this.value != null) {
            props.add((CallSite)((Object)("value='" + this.value + "'")));
        }
        return this.getClass().getSimpleName() + "{" + StringUtils.join(props, (String)", ") + "}";
    }

    public static enum Op {
        AND,
        OR;

    }
}

