/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.marcspec.legacy;

import de.gwdg.metadataqa.marc.utils.SchemaSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MarcSpec
implements SchemaSpec,
Serializable {
    private static final Pattern fieldTagPattern = Pattern.compile("[X0-9]{3,3}|LDR");
    private static final Pattern hasSpacePattern = Pattern.compile("\\s");
    private static final Pattern indicatorPattern = Pattern.compile("[a-z0-9_]");
    private static final Pattern subfieldsPattern = Pattern.compile("[a-z0-9!\\\"#$%&'()*+-./:;<=>?]");
    private String fieldTag;
    private Integer charStart;
    private Integer charEnd;
    private Integer charLength;
    private Map<String, String> subfields = new HashMap<String, String>();
    private String indicator1;
    private String indicator2;

    public MarcSpec() {
    }

    public MarcSpec(String spec) {
        if (StringUtils.isNotBlank((CharSequence)spec)) {
            this.decode(spec);
        }
    }

    public void decode(String spec) {
        this.checkIfString(spec);
        this.validate(spec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validate(String spec) {
        this.checkIfString(spec);
        this.clear();
        spec = StringUtils.trim((String)spec);
        if (3 > spec.length()) {
            throw new IllegalArgumentException("Marc spec must be 3 characters at minimum.");
        }
        if (hasSpacePattern.matcher(spec).matches()) {
            throw new IllegalArgumentException(String.format("For Field Tag of Marc spec no whitespaces are allowed. But \"%s\" given.", spec));
        }
        String fieldTag = spec.substring(0, 3);
        this.setFieldTag(fieldTag);
        String dataRef = spec.substring(3);
        if (dataRef.equals("")) return true;
        if (spec.substring(3, 4).equals("~")) {
            String charPos = spec.substring(4);
            if (charPos.equals("")) throw new IllegalArgumentException("For character position or range minimum one digit is required. None given.");
            int[] _charPos = this.validateCharPos(charPos);
            if (_charPos.length <= 0) return true;
            this.setCharStart(_charPos[0]);
            if (_charPos.length > 1) {
                this.setCharEnd(_charPos[1]);
                return true;
            } else {
                this.setCharLength(1);
                this.setCharEnd(this.charStart);
            }
            return true;
        } else {
            String[] _dataRef = this.validateDataRef(dataRef);
            if (_dataRef == null || _dataRef.length <= 0) return true;
            this.addSubfields(_dataRef[0]);
            if (_dataRef.length <= 1) return true;
            this.setIndicators(_dataRef[1]);
        }
        return true;
    }

    @Override
    public String encode() {
        if (this.fieldTag == null) {
            throw new RuntimeException("No field tag available. Assuming MarcSpec is not initialized.");
        }
        Object marcspec = this.fieldTag;
        if (this.charStart != null) {
            marcspec = (String)marcspec + "~" + this.charStart;
            if (this.charEnd != null) {
                marcspec = (String)marcspec + "-" + this.charEnd;
            }
            return marcspec;
        }
        if (!this.subfields.isEmpty()) {
            marcspec = (String)marcspec + StringUtils.join(this.subfields.keySet(), (String)"");
        }
        if (this.indicator1 != null || this.indicator2 != null) {
            marcspec = this.indicator2 == null ? (String)marcspec + "_" + this.indicator1 : (this.indicator1 == null ? (String)marcspec + "__" + this.indicator2 : (String)marcspec + "_" + this.indicator1 + this.indicator2);
        }
        return marcspec;
    }

    public Integer getCharStart() {
        return this.charStart;
    }

    public String getFieldTag() {
        return this.fieldTag;
    }

    public Integer getCharEnd() {
        if (this.charEnd != null) {
            return this.charEnd;
        }
        if (this.charStart != null && this.charLength != null) {
            return this.charStart + this.charLength - 1;
        }
        return null;
    }

    public Integer getCharLength() {
        if (this.charLength != null) {
            return this.charLength;
        }
        if (this.charStart != null && this.charEnd != null) {
            return this.charEnd - this.charStart + 1;
        }
        return null;
    }

    public Map<String, String> getSubfields() {
        return this.subfields;
    }

    public List<String> getSubfieldsAsList() {
        return new ArrayList<String>(this.subfields.keySet());
    }

    public String getIndicator1() {
        return this.indicator1;
    }

    public String getIndicator2() {
        return this.indicator2;
    }

    public void setIndicators(String arg) {
        this.checkIfString(arg);
        for (int x = 0; x < arg.length(); ++x) {
            String indicator = arg.substring(x, x + 1);
            if (0 == x && !"_".equals(indicator)) {
                this.setIndicator1(indicator);
            }
            if (1 != x || "_".equals(indicator)) continue;
            this.setIndicator2(indicator);
        }
    }

    public void setIndicator1(String indicator) {
        if (this.validateIndicators(indicator)) {
            this.indicator1 = indicator;
        }
    }

    public void setIndicator2(String indicator) {
        if (this.validateIndicators(indicator)) {
            this.indicator2 = indicator;
        }
    }

    public boolean addSubfields(String arg) {
        if (this.charStart != null || "LDR".equals(this.fieldTag)) {
            return false;
        }
        this.checkIfString(arg);
        for (int x = 0; x < arg.length(); ++x) {
            String chr = arg.substring(x, x + 1);
            this.subfields.put(chr, chr);
        }
        return true;
    }

    public boolean hasRangeSelector() {
        return this.charStart != null && this.charEnd != null;
    }

    public String selectRange(String input) {
        return input.substring(this.charStart, this.charEnd + 1);
    }

    private String[] validateDataRef(String dataFieldRef) {
        this.checkIfString(dataFieldRef);
        String[] _ref = dataFieldRef.split("_", 2);
        if (this.validateSubfields(_ref[0]) && _ref.length > 1) {
            this.validateIndicators(_ref[1]);
        }
        return _ref;
    }

    private boolean validateIndicators(String indicators) {
        this.checkIfString(indicators);
        if (2 < indicators.length()) {
            throw new IllegalArgumentException(String.format("For indicators only two characters are allowed. \"%d\" characters given.", indicators.length()));
        }
        for (int x = 0; x < indicators.length(); ++x) {
            String chr = indicators.substring(x, x + 1);
            if (indicatorPattern.matcher(indicators.substring(x, x + 1)).matches()) continue;
            throw new IllegalArgumentException(String.format("For indicators only digits, lowercase alphabetic characters and \"_\" are allowed. But \"%s\" given. Problematic part: '%s'.", indicators, chr));
        }
        return true;
    }

    private boolean validateSubfields(String subfields) {
        for (int x = 0; x < subfields.length(); ++x) {
            String chr = subfields.substring(x, x + 1);
            if (subfieldsPattern.matcher(chr).matches()) continue;
            throw new IllegalArgumentException(String.format("For subfields only digits, lowercase alphabetic characters or one of ... are allowed. But '%s' given. Problem: '%s'.", subfields, chr));
        }
        return true;
    }

    public void setCharLength(int arg) {
        if (0 < arg) {
            if (this.charStart == null) {
                throw new RuntimeException("Character start position must be defined first. Use MarcSpec::setCharStart() first to set the character start position.");
            }
        } else {
            throw new IllegalArgumentException("Argument must be of type positive int without 0.");
        }
        this.charLength = arg;
        this.charEnd = this.charStart + this.charLength - 1;
        this.setCharEnd(this.charEnd);
    }

    public void setCharStart(int arg) {
        if (0 <= arg) {
            this.charStart = arg;
            if (this.charEnd != null) {
                this.charLength = this.charEnd - this.charStart + 1;
            }
        } else {
            throw new IllegalArgumentException("Argument must be of type int.");
        }
    }

    private int[] validateCharPos(String charPos) {
        this.checkIfString(charPos);
        if (charPos.length() < 1) {
            throw new IllegalArgumentException("For character position or range minimum one digit is required. None given.");
        }
        String[] _charPos = charPos.split("-", 3);
        if (2 < _charPos.length) {
            throw new IllegalArgumentException(String.format("For character position or range only digits and one \"-\" is allowed. But \"%s\" given.", charPos));
        }
        int[] positions = new int[_charPos.length];
        for (int i = 0; i < _charPos.length; ++i) {
            positions[i] = Integer.parseInt(_charPos[i]);
        }
        return positions;
    }

    public void setFieldTag(String arg) {
        if (this.validateFieldTag(arg)) {
            this.fieldTag = arg;
        }
    }

    private boolean validateFieldTag(String fieldTag) {
        this.checkIfString(fieldTag);
        if (!fieldTagPattern.matcher(fieldTag).matches()) {
            throw new IllegalArgumentException(String.format("For Field Tag of Marc spec only digits, \"X\" or \"LDR\" is allowed. But \"%s\"  given.", fieldTag));
        }
        return true;
    }

    private void clear() {
        this.fieldTag = null;
        this.charStart = null;
        this.charEnd = null;
        this.charLength = null;
        this.indicator1 = null;
        this.indicator2 = null;
        this.subfields = new HashMap<String, String>();
    }

    private void checkIfString(Object arg) {
        if (!(arg instanceof String)) {
            throw new IllegalArgumentException(String.format("Method decode only accepts string as argument. Given %s.", arg.getClass().getSimpleName()));
        }
    }

    public void setCharEnd(int arg) {
        if (0 <= arg) {
            if (this.charStart == null) {
                throw new RuntimeException("Character start position must be defined first. Use MarcSpec::setCharStart() first to set the character start position.");
            }
        } else {
            throw new IllegalArgumentException("Argument must be of type positive int or 0.");
        }
        this.charEnd = arg;
        this.charLength = this.charEnd - this.charStart + 1;
    }

    public String toString() {
        return "MarcSpec{fieldTag='" + this.fieldTag + "', charStart=" + this.charStart + ", charEnd=" + this.charEnd + ", charLength=" + this.charLength + ", subfields=" + this.subfields + ", indicator1='" + this.indicator1 + "', indicator2='" + this.indicator2 + "'}";
    }
}

