/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.marcspec;

import java.security.InvalidParameterException;
import org.apache.commons.lang3.StringUtils;

public class Position {
    private Integer positionInt;
    private String positionString;
    private boolean isNumeric = true;

    public Position(Integer positionInt) {
        this.isNumeric = true;
        this.positionInt = positionInt;
    }

    public Position(String positionString) {
        this.isNumeric = false;
        if (!positionString.equals("#")) {
            throw new InvalidParameterException("Position can be initialized with numbers or '#' only.");
        }
        this.positionString = positionString;
    }

    public Integer getPositionInt() {
        return this.positionInt;
    }

    public int value() {
        if (this.positionInt != null) {
            return this.positionInt;
        }
        return -1;
    }

    public String getPositionString() {
        return this.positionString;
    }

    public String asString() {
        if (StringUtils.isNotBlank((CharSequence)this.positionString)) {
            return this.positionString;
        }
        return "";
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public boolean isWildcard() {
        return !this.isNumeric;
    }

    public String toString() {
        return "Position{int=" + this.positionInt + ", string='" + this.positionString + "'}";
    }
}

