/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.marcreader;

import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.utils.alephseq.AlephseqLine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.marc4j.MarcReader;
import org.marc4j.marc.Record;

public class AlephseqMarcReader
implements MarcReader {
    private static final Logger logger = Logger.getLogger(AlephseqMarcReader.class.getCanonicalName());
    private BufferedReader bufferedReader = null;
    private String line = null;
    private boolean nextIsConsumed = false;
    private int lineNumber = 0;
    private int skippedRecords = 0;
    private List<AlephseqLine> lines = new ArrayList<AlephseqLine>();
    private String currentId = null;
    private AlephseqLine.TYPE lineType = AlephseqLine.TYPE.WITH_L;

    public AlephseqMarcReader(String alephseqMarc) {
        try {
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(alephseqMarc), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "AlephseqMarcReader", e);
        }
    }

    public AlephseqMarcReader(String alephseqMarc, AlephseqLine.TYPE lineType) {
        this(alephseqMarc);
        this.lineType = lineType;
    }

    public AlephseqMarcReader(InputStream stream) {
        this.bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public boolean hasNext() {
        if (this.lineNumber == 0 || this.nextIsConsumed) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "hasNext", e);
            }
            ++this.lineNumber;
            this.nextIsConsumed = false;
        }
        return this.line != null;
    }

    public Record next() {
        Record marc4jRecord = null;
        boolean deleted = false;
        boolean finished = false;
        while (this.line != null && !finished) {
            AlephseqLine alephseqLine = new AlephseqLine(this.line, this.lineNumber, this.lineType);
            String recordID = alephseqLine.getRecordID();
            if (recordID == null) {
                logger.log(Level.WARNING, "line {0}) does not have line number: \"{1}\"", new Object[]{this.lineNumber, this.line});
            } else {
                if (this.currentId != null && !recordID.equals(this.currentId) && !this.lines.isEmpty()) {
                    if (deleted) {
                        this.logSkipped(LEVEL.WARN, "has been deleted");
                        deleted = false;
                    } else {
                        marc4jRecord = MarcFactory.createRecordFromAlephseq(this.lines);
                        if (marc4jRecord.getControlNumber() == null) {
                            this.logSkipped("does not have a control number field (001)");
                        } else if (marc4jRecord.getLeader() == null) {
                            this.logSkipped("does not have a leader");
                        } else {
                            finished = true;
                        }
                    }
                    this.lines = new ArrayList<AlephseqLine>();
                }
                if (alephseqLine.isValidTag()) {
                    this.lines.add(alephseqLine);
                } else if (alephseqLine.getTag().equals("DEL")) {
                    deleted = true;
                }
                this.currentId = alephseqLine.getRecordID();
            }
            try {
                this.line = this.bufferedReader.readLine();
                ++this.lineNumber;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "next", e);
            }
        }
        if (this.line == null && !this.lines.isEmpty()) {
            marc4jRecord = MarcFactory.createRecordFromAlephseq(this.lines);
        }
        return marc4jRecord;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getSkippedRecords() {
        return this.skippedRecords;
    }

    private void logSkipped(String message) {
        this.logSkipped(LEVEL.SEVERE, message);
    }

    private void logSkipped(LEVEL level, String message) {
        String entry = String.format("line #%d: record %s %s. Skipped.", this.lineNumber, this.currentId, message);
        if (!level.equals((Object)LEVEL.WARN)) {
            logger.severe(entry);
        }
        ++this.skippedRecords;
    }

    public void setLineType(AlephseqLine.TYPE lineType) {
        this.lineType = lineType;
    }

    private static enum LEVEL {
        WARN,
        SEVERE;

    }
}

