/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.keygenerator;

import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;

public class PositionalControlFieldKeyGenerator {
    private String tag;
    private String mqTag;
    private SolrFieldType type;
    private boolean isLeader = false;

    public PositionalControlFieldKeyGenerator(String tag, String mqTag, SolrFieldType type) {
        this.tag = tag;
        this.mqTag = mqTag;
        this.type = type;
        this.isLeader = tag.equals(mqTag);
    }

    public String forTag() {
        String key;
        switch (this.type) {
            case HUMAN: {
                key = this.mqTag;
                break;
            }
            case MIXED: {
                key = this.isLeader ? this.tag : String.format("%s_%s", this.tag, this.mqTag);
                break;
            }
            default: {
                key = this.tag;
            }
        }
        return key;
    }

    public String forSubfield(ControlfieldPositionDefinition subfield) {
        String key;
        String code = subfield.getMqTag() != null ? subfield.getMqTag() : subfield.getId();
        switch (this.type) {
            case HUMAN: {
                key = String.format("%s_%s", this.forTag(), code);
                break;
            }
            case MIXED: {
                if (this.isLeader) {
                    key = String.format("%s_%s", subfield.getId(), code);
                    break;
                }
                key = String.format("%s_%s_%s", subfield.getId(), this.mqTag, code);
                break;
            }
            default: {
                key = String.format("%s_%s", this.forTag(), subfield.formatPositon());
            }
        }
        return key;
    }
}

