/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.definition.structure.ControlFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.MarcDefinition;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.utils.AppendableHashMap;
import de.gwdg.metadataqa.marc.utils.Counter;
import de.gwdg.metadataqa.marc.utils.FunctionValue;
import de.gwdg.metadataqa.marc.utils.MarcTagLister;
import de.gwdg.metadataqa.marc.utils.pica.crosswalk.Crosswalk;
import de.gwdg.metadataqa.marc.utils.pica.crosswalk.PicaMarcCrosswalkReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FrbrFunctionLister {
    private static final Logger logger = Logger.getLogger(FrbrFunctionLister.class.getCanonicalName());
    private SchemaType schemaType;
    private MarcVersion marcVersion;
    private Counter<FRBRFunction> baselineCounter = new Counter();
    private int elementsWithoutFunctions;
    private Map<FRBRFunction, FunctionValue> collector;
    private Map<FRBRFunction, Counter<FunctionValue>> histogram;
    private Map<String, List<FRBRFunction>> functionByMarcPath;
    private Map<String, List<FRBRFunction>> functionByPicaPath;
    private AppendableHashMap<FRBRFunction, String> marcPathByFunction;
    private Map<FRBRFunction, List<String>> picaPathByFunctionCondensed;
    private Map<FRBRFunction, Map<String, List<String>>> picaPathByFunction;

    public FrbrFunctionLister(SchemaType schemaType, MarcVersion marcVersion) {
        this.schemaType = schemaType == null ? SchemaType.MARC21 : schemaType;
        this.marcVersion = marcVersion == null ? MarcVersion.MARC21 : marcVersion;
        this.prepareBaseline();
        this.prepareCollector();
        this.prepareHistogram();
    }

    public FrbrFunctionLister(MarcVersion marcVersion) {
        this(SchemaType.MARC21, marcVersion);
    }

    public FrbrFunctionLister(SchemaType schemaType) {
        this(schemaType, MarcVersion.MARC21);
    }

    public Map<FRBRFunction, Counter<FunctionValue>> getHistogram() {
        return this.histogram;
    }

    public void prepareBaseline() {
        this.elementsWithoutFunctions = 0;
        this.functionByMarcPath = new TreeMap<String, List<FRBRFunction>>();
        this.marcPathByFunction = new AppendableHashMap();
        if (this.schemaType.equals((Object)SchemaType.MARC21)) {
            this.prepareBaselineForMarc21();
        } else if (this.schemaType.equals((Object)SchemaType.PICA)) {
            this.prepareBaselineForMarc21();
            this.initializePica();
            this.functionByMarcPath = new TreeMap<String, List<FRBRFunction>>();
            this.marcPathByFunction = new AppendableHashMap();
            this.prepareBaselineForPica();
        }
    }

    private void prepareBaselineForPica() {
        for (Map.Entry<String, List<FRBRFunction>> entry : this.functionByPicaPath.entrySet()) {
            this.registerFunctions(entry.getValue(), entry.getKey());
        }
    }

    private void prepareBaselineForMarc21() {
        for (ControlfieldPositionDefinition controlfieldPositionDefinition : MarcDefinition.getLeaderPositions()) {
            this.registerFunctions(controlfieldPositionDefinition.getFrbrFunctions(), controlfieldPositionDefinition.getPath(false));
        }
        for (DataFieldDefinition dataFieldDefinition : MarcDefinition.getSimpleControlFields()) {
            this.registerFunctions(dataFieldDefinition.getFrbrFunctions(), dataFieldDefinition.getTag());
        }
        for (ControlFieldDefinition controlFieldDefinition : MarcDefinition.getComplexControlFields()) {
            for (List<ControlfieldPositionDefinition> positions : controlFieldDefinition.getControlfieldPositions().values()) {
                for (ControlfieldPositionDefinition controlfieldPositionDefinition : positions) {
                    this.registerFunctions(controlfieldPositionDefinition.getFrbrFunctions(), controlfieldPositionDefinition.getId().replace("tag", ""));
                }
            }
        }
        for (Class clazz : MarcTagLister.listTags()) {
            MarcVersion currentVersion = Utils.getVersion(clazz);
            try {
                Method getInstance = clazz.getMethod("getInstance", new Class[0]);
                DataFieldDefinition fieldTag = (DataFieldDefinition)getInstance.invoke((Object)clazz, new Object[0]);
                if (currentVersion != MarcVersion.MARC21 && currentVersion != this.marcVersion) continue;
                ++this.elementsWithoutFunctions;
                for (Indicator indicator : fieldTag.getIndicators()) {
                    if (indicator == null) continue;
                    this.registerFunctions(indicator.getFrbrFunctions(), indicator.getPath());
                }
                if (fieldTag.getSubfields() == null) continue;
                for (SubfieldDefinition subfield : fieldTag.getSubfields()) {
                    this.registerFunctions(subfield.getFrbrFunctions(), subfield.getPath());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                logger.log(Level.WARNING, "document", reflectiveOperationException);
            }
        }
    }

    private void registerFunctions(List<FRBRFunction> functions, String marcPath) {
        if (functions != null && !functions.isEmpty()) {
            this.functionByMarcPath.put(marcPath, functions);
            for (FRBRFunction function : functions) {
                this.marcPathByFunction.append(function, marcPath);
                this.baselineCounter.count(function);
            }
        } else {
            ++this.elementsWithoutFunctions;
        }
    }

    public static void countFunctions(List<FRBRFunction> functions, Map<FRBRFunction, FunctionValue> map) {
        if (functions != null && !functions.isEmpty()) {
            for (FRBRFunction function : functions) {
                map.computeIfAbsent(function, s -> new FunctionValue());
                map.get((Object)function).count();
            }
        }
    }

    private void prepareCollector() {
        this.collector = new TreeMap<FRBRFunction, FunctionValue>();
        for (FRBRFunction key : this.baselineCounter.keys()) {
            this.collector.put(key, new FunctionValue());
        }
    }

    private void prepareHistogram() {
        this.histogram = new TreeMap<FRBRFunction, Counter<FunctionValue>>();
        for (FRBRFunction key : this.baselineCounter.keys()) {
            this.histogram.put(key, new Counter());
        }
    }

    public void calculatePercent(Map<FRBRFunction, FunctionValue> other) {
        for (FRBRFunction key : this.baselineCounter.keys()) {
            if (!other.containsKey((Object)key)) continue;
            other.get((Object)key).calculatePercent(this.baselineCounter.get(key));
        }
    }

    public void add(Map<FRBRFunction, FunctionValue> other) {
        for (Map.Entry<FRBRFunction, FunctionValue> entry : other.entrySet()) {
            this.collector.computeIfAbsent(entry.getKey(), s -> new FunctionValue());
            this.collector.get((Object)entry.getKey()).add(entry.getValue());
        }
    }

    public Map<FRBRFunction, List<Double>> percentOf(int total) {
        TreeMap<FRBRFunction, List<Double>> result = new TreeMap<FRBRFunction, List<Double>>();
        for (Map.Entry<FRBRFunction, FunctionValue> entry : this.collector.entrySet()) {
            double avgCount = (double)entry.getValue().getCount() * 1.0 / (double)total;
            double avgPerc = entry.getValue().getPercent() * 1.0 / (double)total;
            result.put(entry.getKey(), Arrays.asList(avgCount, avgPerc));
        }
        return result;
    }

    public void addToHistogram(Map<FRBRFunction, FunctionValue> other) {
        for (Map.Entry<FRBRFunction, FunctionValue> entry : other.entrySet()) {
            FRBRFunction function = entry.getKey();
            FunctionValue value = entry.getValue();
            this.histogram.computeIfAbsent(function, s -> new Counter());
            this.histogram.get((Object)function).count(value);
        }
    }

    public Map<FRBRFunction, Integer> getBaseline() {
        return this.baselineCounter.getMap();
    }

    public Map<FRBRFunction, List<String>> getMarcPathByFunction() {
        return this.marcPathByFunction.getMap();
    }

    public Map<FRBRFunction, Map<String, List<String>>> getPicaPathByFunction() {
        if (this.picaPathByFunction == null) {
            this.initializePica();
        }
        return this.picaPathByFunction;
    }

    public Map<String, List<FRBRFunction>> getFunctionByPicaPath() {
        if (this.functionByPicaPath == null) {
            this.initializePica();
        }
        return this.functionByPicaPath;
    }

    public Map<FRBRFunction, List<String>> getPicaPathByFunctionConcensed() {
        if (this.picaPathByFunctionCondensed == null) {
            this.initializePica();
        }
        return this.picaPathByFunctionCondensed;
    }

    private void initializePica() {
        this.picaPathByFunction = new EnumMap<FRBRFunction, Map<String, List<String>>>(FRBRFunction.class);
        this.picaPathByFunctionCondensed = new EnumMap<FRBRFunction, List<String>>(FRBRFunction.class);
        this.functionByPicaPath = new HashMap<String, List<FRBRFunction>>();
        for (Map.Entry<FRBRFunction, List<String>> entry : this.marcPathByFunction.entrySet()) {
            for (String address : entry.getValue()) {
                if (!address.contains("$")) continue;
                FRBRFunction function = entry.getKey();
                String key = address.replace("$", " $");
                for (Crosswalk crosswalk : PicaMarcCrosswalkReader.lookupMarc21(key)) {
                    String pica = crosswalk.getPica();
                    if (!this.picaPathByFunction.containsKey((Object)function)) {
                        this.picaPathByFunction.put(function, new HashMap());
                    }
                    if (!this.picaPathByFunction.get((Object)function).containsKey(pica)) {
                        this.picaPathByFunction.get((Object)function).put(pica, new ArrayList());
                    }
                    this.picaPathByFunction.get((Object)function).get(pica).add(crosswalk.getPicaUf());
                    if (!this.picaPathByFunctionCondensed.containsKey((Object)function)) {
                        this.picaPathByFunctionCondensed.put(function, new ArrayList());
                    }
                    this.picaPathByFunctionCondensed.get((Object)function).add(pica + crosswalk.getPicaUf());
                    if (!this.functionByPicaPath.containsKey(pica + crosswalk.getPicaUf())) {
                        this.functionByPicaPath.put(pica + crosswalk.getPicaUf(), new ArrayList());
                    }
                    this.functionByPicaPath.get(pica + crosswalk.getPicaUf()).add(function);
                }
            }
        }
    }
}

