/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BasicStatistics {
    private final Map<Integer, Integer> histogram;
    private Integer min = null;
    private Integer max = null;
    private Double mean = null;
    private Double stdDev = null;
    private long count = 0L;

    public BasicStatistics(Map<Integer, Integer> histogram) {
        this.histogram = histogram;
        this.calculate();
    }

    private void calculate() {
        this.count = 0L;
        long sum = 0L;
        if (this.histogram == null || this.histogram.isEmpty()) {
            this.mean = 0.0;
            this.stdDev = 0.0;
            this.min = 0;
            this.max = 0;
        } else {
            for (Map.Entry<Integer, Integer> entry : this.histogram.entrySet()) {
                this.min = this.min == null ? entry.getKey() : Integer.valueOf(Math.min(this.min, entry.getKey()));
                this.max = this.max == null ? entry.getKey() : Integer.valueOf(Math.max(this.max, entry.getKey()));
                this.count += (long)entry.getValue().intValue();
                sum += (long)(entry.getKey() * entry.getValue());
            }
            this.mean = (double)sum * 1.0 / (double)this.count;
            this.calculateStdDevAndMedian();
        }
    }

    private void calculateStdDevAndMedian() {
        double sum = 0.0;
        for (Map.Entry<Integer, Integer> entry : this.histogram.entrySet()) {
            sum += Math.pow((double)entry.getKey().intValue() - this.mean, 2.0);
        }
        this.stdDev = Math.sqrt(sum) / (double)this.count;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public Double getMean() {
        return this.mean;
    }

    public String formatHistogram() {
        ArrayList<CallSite> histogramList = new ArrayList<CallSite>();
        if (this.histogram != null && !this.histogram.isEmpty()) {
            for (Map.Entry<Integer, Integer> histogram : this.histogram.entrySet()) {
                histogramList.add((CallSite)((Object)(histogram.getKey() + "=" + histogram.getValue())));
            }
        }
        return StringUtils.join(histogramList, (String)"; ");
    }

    public Double getStdDev() {
        return this.stdDev;
    }
}

