/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags84x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.ElectronicAccessMethodsCodeList;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag856
extends DataFieldDefinition {
    private static Tag856 uniqueInstance;

    private Tag856() {
        this.initialize();
        this.postCreation();
    }

    public static Tag856 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag856();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "856";
        this.label = "Electronic Location and Access";
        this.mqTag = "ElectronicLocationAndAccess";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd856.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Access method").setCodes(" ", "No information provided", "0", "Email", "1", "FTP", "2", "Remote login (Telnet)", "3", "Dial-up", "4", "HTTP", "7", "Method specified in subfield $2").setMqTag("accessMethod").setFrbrFunctions(FRBRFunction.DiscoveryObtain);
        this.ind2 = new Indicator("Relationship").setCodes(" ", "No information provided", "0", "Resource", "1", "Version of resource", "2", "Related resource", "8", "No display constant generated").setMqTag("relationship").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect);
        this.setSubfieldsWithCardinality("a", "Host name", "R", "c", "Compression information", "R", "d", "Path", "R", "f", "Electronic name", "R", "m", "Contact for access assistance", "R", "o", "Operating system", "NR", "p", "Port", "NR", "q", "Electronic format type", "NR", "s", "File size", "R", "u", "Uniform Resource Identifier", "R", "v", "Hours access method available", "R", "w", "Record control number", "R", "x", "Nonpublic note", "R", "y", "Link text", "R", "z", "Public note", "R", "2", "Access method", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "7", "Access status", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("7").setCodes("0", "Open access", "1", "Restricted access", "u", "Unspecified", "z", "Other");
        this.getSubfield("w").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("host").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("compression").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("path").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("name").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("contact").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("o").setMqTag("operatingSystem").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("port").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("q").setMqTag("format").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("s").setMqTag("fileSize").setCompilanceLevels("O");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("v").setMqTag("hours").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("w").setMqTag("recordControlNumber").setCompilanceLevels("O");
        this.getSubfield("x").setMqTag("nonpublicNote").setCompilanceLevels("O");
        this.getSubfield("y").setMqTag("linkText").setCompilanceLevels("O");
        this.getSubfield("z").setMqTag("publicNote").setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("accessMethod").setCodeList(ElectronicAccessMethodsCodeList.getInstance()).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("7").setMqTag("accessStatus");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("4", "Aleph subfield related to copyright", "NR"), new SubfieldDefinition("9", "Aleph/ANL fulltext linkage", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
        this.setHistoricalSubfields("g", "Uniform Resource Name [OBSOLETE, 2000]", "b", "Access number [OBSOLETE, 2020]", "h", "Processor of request [OBSOLETE, 2020]", "i", "Instruction [OBSOLETE, 2020]", "j", "Bits per second [OBSOLETE, 2020]", "k", "Password [OBSOLETE, 2020]", "l", "Logon [OBSOLETE, 2020]", "n", "Name of location of host [OBSOLETE, 2020]", "r", "Settings [OBSOLETE, 2020]", "t", "Terminal emulation [OBSOLETE, 2020]");
    }
}

