/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags76x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.Tag76xSubfield7PositionsGenerator;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISBNValidator;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag765
extends DataFieldDefinition {
    private static Tag765 uniqueInstance;

    private Tag765() {
        this.initialize();
        this.postCreation();
    }

    public static Tag765 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag765();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "765";
        this.label = "Original Language Entry";
        this.bibframeTag = "TranslationOf";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd765.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Note controller").setCodes("0", "Display note", "1", "Do not display note").setMqTag("noteController").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Display constant controller").setCodes(" ", "Translation of", "8", "No display constant generated").setMqTag("displayConstant").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.setSubfieldsWithCardinality("a", "Main entry heading", "NR", "b", "Edition", "NR", "c", "Qualifying information", "NR", "d", "Place, publisher, and date of publication", "NR", "g", "Related parts", "R", "h", "Physical description", "NR", "i", "Relationship information", "R", "k", "Series data for related item", "R", "m", "Material-specific details", "NR", "n", "Note", "R", "o", "Other item identifier", "R", "r", "Report number", "R", "s", "Uniform title", "NR", "t", "Title", "NR", "u", "Standard Technical Report Number", "NR", "w", "Record control number", "R", "x", "International Standard Serial Number", "NR", "y", "CODEN designation", "NR", "z", "International Standard Book Number", "R", "4", "Relationship", "R", "6", "Linkage", "NR", "7", "Control subfield", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("7").setPositions(Tag76xSubfield7PositionsGenerator.getPositions());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setCompilanceLevels("A");
        this.getSubfield("b").setBibframeTag("editionStatement").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("qualifier").setCompilanceLevels("A");
        this.getSubfield("d").setBibframeTag("provisionActivityStatement").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("g").setBibframeTag("part").setCompilanceLevels("A");
        this.getSubfield("h").setBibframeTag("extent").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("i").setBibframeTag("relation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("k").setBibframeTag("seriesStatement").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("m").setBibframeTag("note").setMqTag("materialSpecificDetails").setCompilanceLevels("O");
        this.getSubfield("n").setBibframeTag("note").setCompilanceLevels("O");
        this.getSubfield("o").setMqTag("otherItemIdentifier").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("r").setMqTag("reportNumber").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("s").setBibframeTag("title").setMqTag("uniformTitle").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("t").setBibframeTag("title").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("u").setBibframeTag("strn").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("w").setMqTag("recordControlNumber").setFrbrFunctions(FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("x").setBibframeTag("issn").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("y").setBibframeTag("coden").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("z").setBibframeTag("isbn").setValidator(ISBNValidator.getInstance()).setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("4").setMqTag("relationship").setCodeList(RelatorCodes.getInstance()).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("7").setMqTag("controlSubfield").setCompilanceLevels("O");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("9", "Language version", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

