/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags70x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag740
extends DataFieldDefinition {
    private static Tag740 uniqueInstance;

    private Tag740() {
        this.initialize();
        this.postCreation();
    }

    public static Tag740 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag740();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "740";
        this.label = "Added Entry - Uncontrolled Related/Analytical Title";
        this.mqTag = "AddedUncontrolledRelatedOrAnalyticalTitle";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd740.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Nonfiling characters").setCodes("0", "No nonfiling characters", "1-9", "Number of nonfiling characters").setHistoricalCodes(" ", "Nonfiling characters not specified [OBSOLETE, 1980]").setMqTag("nonfilingCharacters").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind1.getCode("1-9").setRange(true);
        this.ind2 = new Indicator("Type of added entry").setCodes(" ", "No information provided", "2", "Analytical entry").setHistoricalCodes("0", "Alternative entry (BK, AM, CF, MP, MU) [OBSOLETE, 1993]", "1", "Secondary entry (BK, AM, CF, MP, MU) / Printed on card (VM) [OBSOLETE, 1993]", "3", "Not printed on card [OBSOLETE, 1993]").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Uncontrolled related/analytical title", "NR", "h", "Medium", "NR", "n", "Number of part/section of a work", "R", "p", "Name of part/section of a work", "R", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("n").setBibframeTag("partNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("nameOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

