/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.SubjectHeadingAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag650
extends DataFieldDefinition {
    private static Tag650 uniqueInstance;

    private Tag650() {
        this.initialize();
        this.postCreation();
    }

    public static Tag650 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag650();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "650";
        this.label = "Subject Added Entry - Topical Term";
        this.bibframeTag = "Topic";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd650.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Level of subject").setCodes(" ", "No information provided", "0", "No level specified", "1", "Primary", "2", "Secondary").setMqTag("subjectLevel");
        this.ind2 = new Indicator("Thesaurus").setCodes("0", "Library of Congress Subject Headings", "1", "LC subject headings for children's literature", "2", "Medical Subject Headings", "3", "National Agricultural Library subject authority file", "4", "Source not specified", "5", "Canadian Subject Headings", "6", "R\u00e9pertoire de vedettes-mati\u00e8re", "7", "Source specified in subfield $2").putVersionSpecificCodes(MarcVersion.NKCR, Arrays.asList(new EncodedValue("9", "English variant of term"))).setMqTag("thesaurus").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Topical term or geographic name entry element", "NR", "b", "Topical term following geographic name entry element", "NR", "c", "Location of event", "NR", "d", "Active dates", "NR", "e", "Relator term", "R", "g", "Miscellaneous information", "R", "v", "Form subdivision", "R", "x", "General subdivision", "R", "y", "Chronological subdivision", "R", "z", "Geographic subdivision", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source of heading or term", "NR", "3", "Materials specified", "NR", "4", "Relationship", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(SubjectHeadingAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("topicalTerm").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("topicalTerm").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("locationOfEvent").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("activeDates").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("relatorTerm").setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("miscellaneousInformation").setCompilanceLevels("A");
        this.getSubfield("v").setBibframeTag("formGenre").setMqTag("formSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("x").setBibframeTag("topic").setMqTag("generalSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("y").setBibframeTag("temporal").setMqTag("chronologicalSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("z").setBibframeTag("geographic").setMqTag("geographicSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance()).setCompilanceLevels("A");
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setMqTag("sourceOfHeading").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("4").setMqTag("relationship").setCodeList(RelatorCodes.getInstance()).setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.MARC21NO, Arrays.asList(new SubfieldDefinition("9", "Language code", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
        this.sourceSpecificationType = SourceSpecificationType.Indicator2AndSubfield2;
        this.setHistoricalSubfields("b", "Topical term following geographic name as entry element [OBSOLETE, 1981]");
    }
}

