/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag565
extends DataFieldDefinition {
    private static Tag565 uniqueInstance;

    private Tag565() {
        this.initialize();
        this.postCreation();
    }

    public static Tag565 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag565();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "565";
        this.label = "Case File Characteristics Note";
        this.mqTag = "CaseFileCharacteristics";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd565.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Display constant controller").setCodes(" ", "File size", "0", "Case file characteristics", "8", "No display constant generated").setMqTag("displayConstant").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Number of cases/variables", "NR", "b", "Name of variable", "R", "c", "Unit of analysis", "R", "d", "Universe of data", "R", "e", "Filing scheme or code", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("numberOfCases").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("variableName").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("analysisUnit").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("universeOfData").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("O");
        this.getSubfield("e").setMqTag("filingScheme").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

