/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag561
extends DataFieldDefinition {
    private static Tag561 uniqueInstance;

    private Tag561() {
        this.initialize();
        this.postCreation();
    }

    public static Tag561 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag561();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "561";
        this.label = "Ownership and Custodial History";
        this.mqTag = "CustodialHistory";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd561.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Privacy").setCodes(" ", "No information provided", "0", "Private", "1", "Not private").setMqTag("privacy");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "History", "NR", "u", "Uniform Resource Identifier", "R", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("custodialHistory").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("u").setMqTag("uri").setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("b", "Time of collation (NR) [OBSOLETE, 1997]");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

