/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag552
extends DataFieldDefinition {
    private static Tag552 uniqueInstance;

    private Tag552() {
        this.initialize();
        this.postCreation();
    }

    public static Tag552 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag552();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "552";
        this.label = "Entity and Attribute Information Note";
        this.mqTag = "EntityAndAttributeInformation";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd552.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Entity type label", "NR", "b", "Entity type definition and source", "NR", "c", "Attribute label", "NR", "d", "Attribute definition and source", "NR", "e", "Enumerated domain value", "R", "f", "Enumerated domain value definition and source", "R", "g", "Range domain minimum and maximum", "NR", "h", "Codeset name and source", "NR", "i", "Unrepresentable domain", "NR", "j", "Attribute units of measurement and resolution", "NR", "k", "Beginning and ending date of attribute values", "NR", "l", "Attribute value accuracy", "NR", "m", "Attribute value accuracy explanation", "NR", "n", "Attribute measurement frequency", "NR", "o", "Entity and attribute overview", "R", "p", "Entity and attribute detail citation", "R", "u", "Uniform Resource Identifier", "R", "z", "Display note", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("entityType").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("entityTypeDefinition").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("attribute").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("attributeDefinition").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("enumeratedDomainValue").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("enumeratedDomainValueDefinition").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("range").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("codeset").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("unrepresentableDomain").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("attributeUnits").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("date").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("attributeValueAccuracy").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("attributeValueAccuracyExplanation").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("attributeMeasurementFrequency").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("overview").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("detailCitation").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("z").setMqTag("displayNote").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

