/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.ContentAdviceClassificationSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag520
extends DataFieldDefinition {
    private static Tag520 uniqueInstance;

    private Tag520() {
        this.initialize();
        this.postCreation();
    }

    public static Tag520 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag520();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "520";
        this.label = "Summary, etc.";
        this.bibframeTag = "Summary";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd520.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Display constant controller").setCodes(" ", "Summary", "0", "Subject", "1", "Review", "2", "Scope and content", "3", "Abstract", "4", "Content advice", "8", "No display constant generated").putVersionSpecificCodes(MarcVersion.NKCR, Arrays.asList(new EncodedValue("9", "MKP annotation for the Union catalog"))).setMqTag("displayConstant").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator().putVersionSpecificCodes(MarcVersion.NKCR, Arrays.asList(new EncodedValue("9", "Annotation language specified in subfield $9")));
        this.setSubfieldsWithCardinality("a", "Summary, etc.", "NR", "b", "Expansion of summary note", "NR", "c", "Assigning source", "NR", "u", "Uniform Resource Identifier", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(ContentAdviceClassificationSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("expansion").setCompilanceLevels("O");
        this.getSubfield("c").setMqTag("assigningSource").setCompilanceLevels("O");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source").setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("9", "Annotation language code", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
        this.setHistoricalSubfields("z", "Source of note information (BK, AM, CF, SE) [OBSOLETE, 1990]");
    }
}

