/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.AvailabilityStatusCodeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.CountryCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag366
extends DataFieldDefinition {
    private static Tag366 uniqueInstance;

    private Tag366() {
        this.initialize();
        this.postCreation();
    }

    public static Tag366 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag366();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "366";
        this.label = "Trade Availability Information";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd366.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Publishers' compressed title identification", "NR", "b", "Detailed date of publication", "NR", "c", "Availability status code", "NR", "d", "Expected next availability date", "NR", "e", "Note", "NR", "f", "Publisher's discount category", "NR", "g", "Date made out of print", "NR", "j", "ISO country code", "NR", "k", "MARC country code", "NR", "m", "Identification of agency", "NR", "2", "Source of availability status code", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("k").setCodeList(CountryCodes.getInstance());
        this.getSubfield("2").setCodeList(AvailabilityStatusCodeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("compressedTitle").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("detailedDateOfPublication").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("availability").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("nextAvailabilityDate").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("note").setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("discountCategory").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("dateMadeOutOfPrint").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("isoCountryCode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("marcCountryCode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("agency").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("2").setBibframeTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

