/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag346
extends DataFieldDefinition {
    private static Tag346 uniqueInstance;

    private Tag346() {
        this.initialize();
        this.postCreation();
    }

    public static Tag346 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag346();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "346";
        this.label = "Video Characteristics";
        this.bibframeTag = "VideoCharacteristic";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd346.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Video format", "R", "b", "Broadcast standard", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("videoFormat");
        this.getSubfield("b").setBibframeTag("broadcastStandard");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setBibframeTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

