/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.GeographicAreaCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.GeographicAreaSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag043
extends DataFieldDefinition {
    private static Tag043 uniqueInstance;

    private Tag043() {
        this.initialize();
        this.postCreation();
    }

    public static Tag043 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag043();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "043";
        this.label = "Geographic Area Code";
        this.bibframeTag = "GeographicCoverage";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd043.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Geographic area code", "R", "b", "Local GAC code", "R", "c", "ISO code", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source of local code", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setCodeList(GeographicAreaCodes.getInstance());
        this.getSubfield("2").setCodeList(GeographicAreaSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("code").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("localGACcode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("O");
        this.getSubfield("c").setMqTag("ISOcode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect);
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

