/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.DescriptionConventionSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.LanguageCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag040
extends DataFieldDefinition {
    private static Tag040 uniqueInstance;

    private Tag040() {
        this.initialize();
        this.postCreation();
    }

    public static Tag040 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag040();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "040";
        this.label = "Cataloging Source";
        this.bibframeTag = "AdminMetadata";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd040.html";
        this.setCompilanceLevels("M", "M");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Original cataloging agency", "NR", "b", "Language of cataloging", "NR", "c", "Transcribing agency", "NR", "d", "Modifying agency", "R", "e", "Description conventions", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("b").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("e").setCodeList(DescriptionConventionSourceCodes.getInstance());
        OrganizationCodes orgCodes = OrganizationCodes.getInstance();
        this.getSubfield("a").setCodeList(orgCodes);
        this.getSubfield("c").setCodeList(orgCodes);
        this.getSubfield("d").setCodeList(orgCodes);
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("catalogingAgency").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("b").setMqTag("languageOfCataloging").setFrbrFunctions(FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("c").setMqTag("transcribingAgency").setFrbrFunctions(FRBRFunction.ManagementProcess).setCompilanceLevels("M", "M");
        this.getSubfield("d").setMqTag("modifyingAgency").setFrbrFunctions(FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("e").setMqTag("descriptionConventions").setFrbrFunctions(FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("9", "Record completeness", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

