/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.oclctags;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import java.util.Arrays;

public class Tag029
extends DataFieldDefinition {
    private static Tag029 uniqueInstance;

    private Tag029() {
        this.initialize();
        this.postCreation();
    }

    public static Tag029 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag029();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "029";
        this.label = "Other System Control Number";
        this.bibframeTag = "IdentifiedBy/Lccn";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "http://www.oclc.org/bibformats/en/0xx/029.html";
        this.ind1 = new Indicator("The type of system control number").setCodes("0", "Primary control number", "1", "Secondary control number").putVersionSpecificCodes(MarcVersion.DNB, Arrays.asList(new EncodedValue("a", "ISSN formal richtig"), new EncodedValue("b", "ISSN formal falsch"))).setMqTag("type");
        this.ind2 = new Indicator().putVersionSpecificCodes(MarcVersion.DNB, Arrays.asList(new EncodedValue(" ", "Nicht spezifiziert (bei fehlerhaften ISSN)"), new EncodedValue("a", "Autorisierte ISSN"), new EncodedValue("b", "ISSN der Ausgabe auf anderem Datentr\u00e4ger"), new EncodedValue("c", "ISSN der Internet-Ausgabe"), new EncodedValue("d", "ISSN der Druck-Ausgabe")));
        this.setSubfieldsWithCardinality("a", "OCLC library identifier", "NR", "b", "System control number", "NR", "c", "OAI set name", "NR", "t", "Content type identifier", "NR");
        this.getSubfield("a").setMqTag("oclcLibraryIdentifier");
        this.getSubfield("b").setMqTag("otherSystemControlNumber");
        this.getSubfield("c").setMqTag("oaiSet");
        this.getSubfield("t").setMqTag("contentTypeIdentifier");
    }
}

