/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.bltags;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.general.validator.RangeValidator;
import de.gwdg.metadataqa.marc.definition.general.validator.RegexValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class TagVIT
extends DataFieldDefinition {
    private static TagVIT uniqueInstance;

    private TagVIT() {
        this.initialize();
        this.postCreation();
    }

    public static TagVIT getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new TagVIT();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "VIT";
        this.label = "Virtual Item";
        this.mqTag = "VirtualItem";
        this.cardinality = Cardinality.Repeatable;
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("b", "The Barcode Identifier allocated to the Primary Item", "NR", "c", "Condition/Surrogacy Status", "NR", "d", "Item Description", "NR", "e", "From Year", "NR", "f", "From Month", "NR", "g", "From Day", "NR", "i", "From Year (and To Year if different)", "NR", "j", "From Month (and To Month if different)", "NR", "k", "From Day (and To Day if different)", "NR", "o", "OPAC Note", "NR", "s", "Contains the string \u2018Supplement\u2019 if the Newspaper Audit database Item Description field contained \u2018supp\u2019. Otherwise blank", "NR");
        this.getSubfield("b").setValidator(new RegexValidator("^.*[^\\.]$")).setMqTag("barcode");
        this.getSubfield("c").setValidator(new RegexValidator("^.*[^\\.]$")).setMqTag("status");
        this.getSubfield("d").setValidator(new RegexValidator("^.*[^\\.]$")).setMqTag("description");
        this.getSubfield("e").setValidator(new RegexValidator("^(1[5-9]|20)\\d\\d$")).setMqTag("fromYear");
        this.getSubfield("f").setValidator(new RangeValidator(1, 12)).setMqTag("fromMonth");
        this.getSubfield("g").setValidator(new RangeValidator(1, 31)).setMqTag("fromDay");
        this.getSubfield("i").setValidator(new RegexValidator("^(1[5-9]|20)\\d\\d(/(1[6-9]|20)\\d\\d)?$")).setMqTag("fromToYear");
        this.getSubfield("j").setValidator(new RegexValidator("^(0[1-9]|1[0-2])(/(0[1-9]|1[0-2]))?$")).setMqTag("fromToMonth");
        this.getSubfield("k").setValidator(new RegexValidator("^(0[1-9]|[1-2]\\d|3[01])(/(0[1-9]|[1-2]\\d|3[01]))?$")).setMqTag("fromToDay");
        this.getSubfield("o").setValidator(new RegexValidator("^.*[^\\.]$")).setMqTag("opacNote");
        this.getSubfield("s").setValidator(new RegexValidator("^(Supplement|)$")).setMqTag("isSupplement");
    }
}

