/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.parser;

import de.gwdg.metadataqa.marc.definition.general.codelist.CodeList;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecordControlNumberParser
implements SubfieldContentParser,
Serializable {
    private static final Pattern REGEX = Pattern.compile("^\\((.{1,100})\\)(.{1,100})$");
    private CodeList codeList = OrganizationCodes.getInstance();
    private static RecordControlNumberParser uniqueInstance;

    @Override
    public Map<String, String> parse(String content) {
        HashMap<String, String> extra = new HashMap<String, String>();
        Matcher matcher = REGEX.matcher(content);
        if (matcher.find()) {
            extra.put("organizationCode", matcher.group(1));
            extra.put("recordNumber", matcher.group(2));
            if (this.codeList.isValid(matcher.group(1))) {
                extra.put("organization", this.codeList.getCode(matcher.group(1)).getLabel());
            }
        }
        return extra;
    }

    private RecordControlNumberParser() {
    }

    public static RecordControlNumberParser getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new RecordControlNumberParser();
        }
        return uniqueInstance;
    }
}

