/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.indexer.subject;

import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.definition.general.indexer.FieldIndexer;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.ClassificationSchemes;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SubjectIndexer;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaFromInd2
extends SubjectIndexer
implements FieldIndexer {
    private static SchemaFromInd2 uniqueInstance;

    @Override
    public Map<String, List<String>> index(DataField dataField, DataFieldKeyGenerator keyGenerator) {
        String schemaAbbreviation;
        HashMap<String, List<String>> indexEntries = new HashMap<String, List<String>>();
        try {
            schemaAbbreviation = ClassificationSchemes.getInstance().resolve(dataField.resolveInd2());
        }
        catch (IllegalArgumentException e) {
            schemaAbbreviation = dataField.getInd2().equals(" ") ? "" : dataField.getInd2();
        }
        SubjectIndexer.KeyValuesExtractor extractor = new SubjectIndexer.KeyValuesExtractor(this, dataField, keyGenerator, schemaAbbreviation).invoke();
        if (extractor.hadSuccess()) {
            indexEntries.put(extractor.getKey(), extractor.getValues());
        }
        return indexEntries;
    }

    private SchemaFromInd2() {
    }

    public static SchemaFromInd2 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new SchemaFromInd2();
        }
        return uniqueInstance;
    }
}

