/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general;

import de.gwdg.metadataqa.marc.definition.general.LinkType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldLinkAndSequenceNumberParser {
    public static final Pattern TWO_NUMBERS_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\\\([acprux])$");
    public static final Pattern ONE_NUMBER_PATTERN = Pattern.compile("^(\\d+)\\\\([acprux])$");
    private Integer linkingNumber;
    private Integer sequenceNumber;
    private String fieldLinkTypeChar;
    private LinkType fieldLinkType;
    private String input;

    public FieldLinkAndSequenceNumberParser(String input) {
        this.input = input;
        this.parse();
    }

    private void parse() {
        Matcher matcher = TWO_NUMBERS_PATTERN.matcher(this.input);
        if (matcher.matches()) {
            this.linkingNumber = Integer.parseInt(matcher.group(1));
            this.sequenceNumber = Integer.parseInt(matcher.group(2));
            this.fieldLinkTypeChar = matcher.group(3);
        } else {
            matcher = ONE_NUMBER_PATTERN.matcher(this.input);
            if (matcher.matches()) {
                this.linkingNumber = Integer.parseInt(matcher.group(1));
                this.fieldLinkTypeChar = matcher.group(2);
            }
        }
        if (this.fieldLinkTypeChar != null) {
            this.fieldLinkType = LinkType.byCode(this.fieldLinkTypeChar);
        }
    }

    public Integer getLinkingNumber() {
        return this.linkingNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getFieldLinkTypeChar() {
        return this.fieldLinkTypeChar;
    }

    public LinkType getFieldLinkType() {
        return this.fieldLinkType;
    }
}

