/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.dao;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.TagDefinitionLoader;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.definition.general.indexer.FieldIndexer;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd1OrIf7FromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd1OrIfEmptyFromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2AndSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2For055OrIf7FromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SubjectIndexer;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ErrorsCollector;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DataField
implements Extractable,
Serializable {
    private static final Logger logger = Logger.getLogger(DataField.class.getCanonicalName());
    private DataFieldDefinition definition;
    private String tag;
    private String ind1;
    private String ind2;
    private List<MarcSubfield> subfields;
    private Map<String, List<MarcSubfield>> subfieldIndex = new LinkedHashMap<String, List<MarcSubfield>>();
    private String occurrence;
    private ErrorsCollector errors = null;
    private List<String> unhandledSubfields = null;
    private BibliographicRecord marcRecord;
    private List<FieldIndexer> fieldIndexers;
    private boolean fieldIndexerInitialized = false;

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2) {
        this.definition = definition;
        this.ind1 = ind1;
        this.ind2 = ind2;
        this.subfields = new ArrayList<MarcSubfield>();
    }

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2, List<Map<String, String>> subfields) {
        this(definition, ind1, ind2);
        if (subfields != null) {
            for (Map<String, String> subfield : subfields) {
                String code = subfield.get("code");
                String value = subfield.get("content");
                SubfieldDefinition subfieldDefinition = definition.getSubfield(code);
                if (subfieldDefinition == null) {
                    if (definition.getTag().equals("886") && code.equals("k") || definition.getTag().equals("936")) continue;
                    System.err.printf("no definition for %s$%s (value: '%s') %s %s%n", definition.getTag(), code, value, definition.getTag().equals("886"), code.equals("k"));
                    continue;
                }
                MarcSubfield marcSubfield = new MarcSubfield(subfieldDefinition, code, value);
                marcSubfield.setField(this);
                this.subfields.add(marcSubfield);
                this.indexSubfield(code, marcSubfield);
            }
        }
    }

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2, String ... subfields) {
        this(definition, ind1, ind2);
        if (subfields != null) {
            this.parseSubfieldArray(subfields);
        }
    }

    public DataField(String tag, String input) {
        this(tag, input, MarcVersion.MARC21);
    }

    public DataField(String tag, String input, MarcVersion version) {
        this.definition = TagDefinitionLoader.load(tag, version);
        if (this.definition == null) {
            this.tag = tag;
        }
        this.subfields = new ArrayList<MarcSubfield>();
        this.ind1 = input.substring(0, 1);
        this.ind2 = input.substring(1, 2);
        this.parseAndAddSubfields(input.substring(2));
    }

    public DataField(String tag, String ind1, String ind2, MarcVersion marcVersion) {
        this.definition = TagDefinitionLoader.load(tag, marcVersion);
        if (this.definition == null) {
            this.tag = tag;
        }
        this.ind1 = ind1;
        this.ind2 = ind2;
        this.subfields = new ArrayList<MarcSubfield>();
    }

    public DataField(String tag, String ind1, String ind2, String content, MarcVersion marcVersion) {
        this.definition = TagDefinitionLoader.load(tag, marcVersion);
        if (this.definition == null) {
            this.tag = tag;
        }
        this.ind1 = ind1;
        this.ind2 = ind2;
        this.subfields = new ArrayList<MarcSubfield>();
        this.parseAndAddSubfields(content);
    }

    private void parseAndAddSubfields(String content) {
        for (String[] sf : DataField.parseSubfields(content)) {
            this.addSubfield(sf[0], sf[1]);
        }
    }

    public static List<String[]> parseSubfields(String content) {
        ArrayList<String[]> subfields = new ArrayList<String[]>();
        boolean codeFlag = false;
        String code = null;
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < content.length(); ++i) {
            String c = Character.toString(content.charAt(i));
            if (c.equals("$")) {
                codeFlag = true;
                if (code != null) {
                    subfields.add(new String[]{code, value.toString()});
                }
                code = null;
                value = new StringBuffer();
                continue;
            }
            if (codeFlag) {
                code = c;
                codeFlag = false;
                continue;
            }
            value.append(c);
        }
        subfields.add(new String[]{code, value.toString()});
        return subfields;
    }

    public BibliographicRecord getMarcRecord() {
        return this.marcRecord;
    }

    public void setMarcRecord(BibliographicRecord marcRecord) {
        this.marcRecord = marcRecord;
        for (MarcSubfield marcSubfield : this.subfields) {
            marcSubfield.setMarcRecord(marcRecord);
        }
    }

    public void indexSubfields() {
        for (MarcSubfield marcSubfield : this.subfields) {
            this.indexSubfield(marcSubfield.getCode(), marcSubfield);
        }
    }

    private void indexSubfield(String code, MarcSubfield marcSubfield) {
        this.subfieldIndex.computeIfAbsent(code, s -> new LinkedList());
        this.subfieldIndex.get(code).add(marcSubfield);
    }

    private void parseSubfieldArray(String[] subfields) {
        for (int i = 0; i < subfields.length; i += 2) {
            String code = subfields[i];
            String value = subfields[i + 1];
            this.addSubfield(code, value);
        }
    }

    private void addSubfield(String code, String value) {
        SubfieldDefinition subfieldDefinition = this.definition != null ? this.definition.getSubfield(code) : null;
        MarcSubfield marcSubfield = new MarcSubfield(subfieldDefinition, code, value);
        marcSubfield.setField(this);
        this.subfields.add(marcSubfield);
        this.indexSubfield(code, marcSubfield);
    }

    public Map<String, List<String>> getHumanReadableMap() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        if (this.definition.getInd1().exists()) {
            map.put(this.definition.getInd1().getLabel(), Arrays.asList(this.resolveInd1()));
        }
        if (this.definition.getInd2().exists()) {
            map.put(this.definition.getInd2().getLabel(), Arrays.asList(this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            map.computeIfAbsent(subfield.getLabel(), s -> new ArrayList());
            ((List)map.get(subfield.getLabel())).add(subfield.resolve());
        }
        return map;
    }

    public String simpleFormat() {
        StringBuffer output = new StringBuffer();
        output.append(this.ind1);
        output.append(this.ind2);
        output.append(" ");
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("$%s%s", subfield.getDefinition().getCode(), subfield.getValue()));
        }
        return output.toString();
    }

    public String format() {
        StringBuffer output = new StringBuffer();
        if (this.definition != null) {
            output.append(String.format("[%s: %s]%n", this.definition.getTag(), this.definition.getLabel()));
        } else {
            output.append(String.format("[%s]%n", this.getTag()));
        }
        if (this.definition != null && this.definition.getInd1() != null && this.definition.getInd1().exists()) {
            output.append(String.format("%s: %s%n", this.definition.getInd1().getLabel(), this.resolveInd1()));
        } else if (StringUtils.isNotBlank((CharSequence)this.getInd1())) {
            output.append(String.format("ind1: %s%n", this.getInd1()));
        }
        if (this.definition != null && this.definition.getInd2() != null && this.definition.getInd2().exists()) {
            output.append(String.format("%s: %s%n", this.definition.getInd2().getLabel(), this.resolveInd2()));
        } else if (StringUtils.isNotBlank((CharSequence)this.getInd2())) {
            output.append(String.format("ind2: %s%n", this.getInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("%s: %s%n", subfield.getLabel(), subfield.resolve()));
        }
        return output.toString();
    }

    public String formatAsText() {
        StringBuffer output = new StringBuffer();
        output.append(this.getTag());
        output.append(" ").append(this.ind1).append(this.ind2).append(" ");
        boolean first = true;
        for (MarcSubfield subfield : this.subfields) {
            if (!first) {
                output.append("       ");
            }
            output.append("$").append(subfield.getCode()).append(" ").append(subfield.getValue()).append("\n");
            first = false;
        }
        return output.toString();
    }

    public String formatAsMarc() {
        StringBuffer output = new StringBuffer();
        if (this.definition != null && this.definition.getInd1().exists()) {
            output.append(String.format("%s_ind1: %s%n", this.getTag(), this.resolveInd1()));
        }
        if (this.definition != null && this.definition.getInd2().exists()) {
            output.append(String.format("%s_ind2: %s%n", this.getTag(), this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("%s_%s: %s%n", this.getTag(), subfield.getCode(), subfield.resolve()));
        }
        return output.toString();
    }

    public String formatForIndex() {
        StringBuffer output = new StringBuffer();
        if (this.definition.getInd1().exists()) {
            output.append(String.format("%s_ind1: %s%n", this.definition.getIndexTag(), this.resolveInd1()));
        }
        if (this.definition.getInd2().exists()) {
            output.append(String.format("%s_ind2: %s%n", this.definition.getIndexTag(), this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            Map<String, String> extra;
            String code = subfield.getCodeForIndex();
            output.append(String.format("%s%s: %s%n", this.definition.getIndexTag(), code, subfield.resolve()));
            if (subfield.getDefinition() == null || !subfield.getDefinition().hasContentParser() || (extra = subfield.parseContent()) == null) continue;
            for (Map.Entry<String, String> entry : extra.entrySet()) {
                output.append(String.format("%s%s_%s: %s%n", this.definition.getIndexTag(), code, entry.getKey(), entry.getValue()));
            }
        }
        return output.toString();
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type) {
        return this.getKeyValuePairs(type, MarcVersion.MARC21);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type, MarcVersion marcVersion) {
        String value;
        ArrayList<String> full;
        boolean hasInd2def;
        boolean hasInd1def;
        HashMap<String, List<String>> pairs = new HashMap<String, List<String>>();
        Object tag = this.getTag();
        if (this.getOccurrence() != null) {
            tag = (String)tag + "_" + this.getOccurrence();
        }
        SchemaType schemaType = this.marcRecord != null ? this.marcRecord.getSchemaType() : SchemaType.MARC21;
        DataFieldKeyGenerator keyGenerator = new DataFieldKeyGenerator(this.definition, type, (String)tag, schemaType);
        keyGenerator.setMarcVersion(marcVersion);
        boolean bl = hasInd1def = this.definition != null && this.definition.getInd1() != null && this.definition.getInd1().exists();
        if (hasInd1def || !this.getInd1().equals(" ")) {
            String value3 = hasInd1def ? this.resolveInd1() : this.getInd1();
            pairs.put(keyGenerator.forInd1(), Arrays.asList(value3));
        }
        boolean bl2 = hasInd2def = this.definition != null && this.definition.getInd2() != null && this.definition.getInd2().exists();
        if (hasInd2def || !this.getInd2().equals(" ")) {
            Iterator<FieldIndexer> value4 = hasInd2def ? this.resolveInd2() : this.getInd2();
            pairs.put(keyGenerator.forInd2(), Arrays.asList(value4));
        }
        for (MarcSubfield marcSubfield : this.subfields) {
            Utils.mergeMap(pairs, marcSubfield.getKeyValuePairs(keyGenerator));
        }
        if (this.getFieldIndexers() != null && !this.getFieldIndexers().isEmpty()) {
            try {
                for (FieldIndexer fieldIndexer : this.getFieldIndexers()) {
                    Map<String, List<String>> extra = fieldIndexer.index(this, keyGenerator);
                    Utils.mergeMap(pairs, extra);
                }
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.SEVERE, "{0} in record {1} {2}", new Object[]{e.getLocalizedMessage(), this.marcRecord.getId(), this.toString()});
            }
        }
        if (this.marcRecord != null && this.marcRecord.isAuthorityTag(this.getTag())) {
            full = new ArrayList<String>();
            for (MarcSubfield subfield : this.subfields) {
                if (this.marcRecord.isSkippableAuthoritySubfield(this.getTag(), subfield.getCode())) continue;
                Object value2 = subfield.getValue();
                if (this.marcRecord.getSchemaType().equals((Object)SchemaType.PICA)) {
                    if (subfield.getCode().equals("E")) {
                        value2 = (String)value2 + "-";
                        if (this.subfieldIndex.containsKey("M")) {
                            value2 = (String)value2 + this.subfieldIndex.get("M").get(0).getValue();
                        }
                    } else if (subfield.getCode().equals("M") && this.subfieldIndex.containsKey("E")) continue;
                }
                full.add((String)value2);
            }
            String string = keyGenerator.forFull();
            value = StringUtils.join(full, (String)", ");
            if (!pairs.containsKey(string)) {
                pairs.put(string, new ArrayList());
            }
            ((List)pairs.get(string)).add(value);
        }
        if (this.marcRecord != null && this.marcRecord.isSubjectTag(this.getTag())) {
            full = new ArrayList();
            for (MarcSubfield subfield : this.subfields) {
                if (this.marcRecord.isSkippableSubjectSubfield(this.getTag(), subfield.getCode())) continue;
                String value2 = subfield.getValue();
                full.add(value2);
            }
            String string = keyGenerator.forFull();
            value = StringUtils.join(full, (String)", ");
            if (!pairs.containsKey(string)) {
                pairs.put(string, new ArrayList());
            }
            ((List)pairs.get(string)).add(value);
        }
        return pairs;
    }

    private FieldIndexer getFieldIndexer() {
        SubjectIndexer fieldIndexer = null;
        if (this.definition != null && this.definition.getSourceSpecificationType() != null) {
            SourceSpecificationType specificationType = this.definition.getSourceSpecificationType();
            switch (specificationType) {
                case Indicator1Is7AndSubfield2: {
                    fieldIndexer = SchemaFromInd1OrIf7FromSubfield2.getInstance();
                    break;
                }
                case Indicator1IsSpaceAndSubfield2: {
                    fieldIndexer = SchemaFromInd1OrIfEmptyFromSubfield2.getInstance();
                    break;
                }
                case Indicator2AndSubfield2: {
                    fieldIndexer = SchemaFromInd2AndSubfield2.getInstance();
                    break;
                }
                case Indicator2For055AndSubfield2: {
                    fieldIndexer = SchemaFromInd2For055OrIf7FromSubfield2.getInstance();
                    break;
                }
                case Subfield2: {
                    fieldIndexer = SchemaFromSubfield2.getInstance();
                    break;
                }
                case Indicator2: {
                    fieldIndexer = SchemaFromInd2.getInstance();
                }
            }
        }
        return fieldIndexer;
    }

    public void addFieldIndexer(FieldIndexer indexer) {
        if (this.fieldIndexers == null) {
            this.fieldIndexers = new ArrayList<FieldIndexer>();
        }
        if (indexer != null) {
            this.fieldIndexers.add(indexer);
        }
    }

    public List<FieldIndexer> getFieldIndexers() {
        if (!this.fieldIndexerInitialized) {
            this.addFieldIndexer(this.getFieldIndexer());
            this.fieldIndexerInitialized = true;
        }
        return this.fieldIndexers;
    }

    public String resolveInd1() {
        return this.resolveIndicator(this.definition.getInd1(), this.ind1);
    }

    public String resolveInd2() {
        return this.resolveIndicator(this.definition.getInd2(), this.ind2);
    }

    public String resolveIndicator(Indicator indicatorDefinition, String indicator) {
        if (indicatorDefinition == null) {
            return indicator;
        }
        if (!indicatorDefinition.exists()) {
            return indicator;
        }
        if (!indicatorDefinition.hasCode(indicator)) {
            return indicator;
        }
        EncodedValue indCode = indicatorDefinition.getCode(indicator);
        assert (indCode != null);
        if (indCode.isRange()) {
            return indCode.getLabel() + ": " + indicator;
        }
        return indCode.getLabel();
    }

    public String getTag() {
        return this.definition != null ? this.definition.getTag() : this.tag;
    }

    public String getInd1() {
        return this.ind1;
    }

    public String getInd2() {
        return this.ind2;
    }

    public List<MarcSubfield> getSubfield(String code) {
        return this.subfieldIndex.getOrDefault(code, null);
    }

    public List<MarcSubfield> getSubfields() {
        return this.subfields;
    }

    public DataFieldDefinition getDefinition() {
        return this.definition;
    }

    public DataFieldKeyGenerator getKeyGenerator(SolrFieldType type) {
        return new DataFieldKeyGenerator(this.getDefinition(), type);
    }

    public void addUnhandledSubfields(String code) {
        if (this.unhandledSubfields == null) {
            this.unhandledSubfields = new ArrayList<String>();
        }
        this.unhandledSubfields.add(code);
    }

    public List<String> getUnhandledSubfields() {
        return this.unhandledSubfields;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(String occurrence) {
        this.occurrence = occurrence;
    }

    public String getTagWithOccurrence() {
        if (this.occurrence == null) {
            return this.getTag();
        }
        return this.getTag() + "/" + this.occurrence;
    }

    public String toString() {
        return "DataField{" + (StringUtils.isNotBlank((CharSequence)this.tag) ? this.tag : (this.definition != null ? this.definition.getTag() : "unknown")) + ", ind1='" + this.ind1 + "', ind2='" + this.ind2 + "', subfields=" + this.subfields + "}";
    }
}

