/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.dao;

import de.gwdg.metadataqa.marc.dao.Leader;
import de.gwdg.metadataqa.marc.dao.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.controlpositions.Control008Positions;
import de.gwdg.metadataqa.marc.definition.controltype.Control008Type;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control008Definition;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Control008
extends MarcPositionalControlField
implements Serializable {
    private static final Logger logger = Logger.getLogger(Control008.class.getCanonicalName());
    private ControlValue tag008all00;
    private ControlValue tag008all06;
    private ControlValue tag008all07;
    private ControlValue tag008all11;
    private ControlValue tag008all15;
    private ControlValue tag008all35;
    private ControlValue tag008all38;
    private ControlValue tag008all39;
    private ControlValue tag008book18;
    private ControlValue tag008book22;
    private ControlValue tag008book23;
    private ControlValue tag008book24;
    private ControlValue tag008book28;
    private ControlValue tag008book29;
    private ControlValue tag008book30;
    private ControlValue tag008book31;
    private ControlValue tag008book33;
    private ControlValue tag008book34;
    private ControlValue tag008computer22;
    private ControlValue tag008computer23;
    private ControlValue tag008computer26;
    private ControlValue tag008computer28;
    private ControlValue tag008map18;
    private ControlValue tag008map22;
    private ControlValue tag008map25;
    private ControlValue tag008map28;
    private ControlValue tag008map29;
    private ControlValue tag008map31;
    private ControlValue tag008map33;
    private ControlValue tag008music18;
    private ControlValue tag008music20;
    private ControlValue tag008music21;
    private ControlValue tag008music22;
    private ControlValue tag008music23;
    private ControlValue tag008music24;
    private ControlValue tag008music30;
    private ControlValue tag008music33;
    private ControlValue tag008continuing18;
    private ControlValue tag008continuing19;
    private ControlValue tag008continuing21;
    private ControlValue tag008continuing22;
    private ControlValue tag008continuing23;
    private ControlValue tag008continuing24;
    private ControlValue tag008continuing25;
    private ControlValue tag008continuing28;
    private ControlValue tag008continuing29;
    private ControlValue tag008continuing33;
    private ControlValue tag008continuing34;
    private ControlValue tag008visual18;
    private ControlValue tag008visual22;
    private ControlValue tag008visual28;
    private ControlValue tag008visual29;
    private ControlValue tag008visual33;
    private ControlValue tag008visual34;
    private ControlValue tag008mixed23;
    private final Map<Control008Type, List<ControlValue>> fieldGroups = new EnumMap<Control008Type, List<ControlValue>>(Control008Type.class);
    private final Map<Integer, ControlfieldPositionDefinition> byPosition = new LinkedHashMap<Integer, ControlfieldPositionDefinition>();
    private Control008Type actual008Type;

    public Control008(String content, Leader.Type recordType) {
        super(Control008Definition.getInstance(), content, recordType);
        this.initialize();
    }

    public Control008(String content, BibliographicRecord marcRecord) {
        super(Control008Definition.getInstance(), content, marcRecord.getType());
        this.marcRecord = marcRecord;
        this.initialize();
    }

    public void initialize() {
        if (this.recordType == null) {
            throw new InvalidParameterException(String.format("Record type is null. 008 content: '%s'", this.content));
        }
        this.actual008Type = Control008Type.byCode(this.recordType.getValue());
        this.processContent();
    }

    @Override
    protected void processContent() {
        ControlValue controlValue;
        String value;
        int end;
        for (ControlfieldPositionDefinition subfield : Control008Positions.getInstance().get(Control008Type.ALL_MATERIALS)) {
            end = Math.min(this.content.length(), subfield.getPositionEnd());
            if (end < 0) {
                logger.severe(this.content.length() + " " + subfield.getPositionEnd());
            }
            value = null;
            if (subfield.getPositionStart() > this.content.length() || subfield.getPositionStart() >= end) break;
            try {
                value = this.content.substring(subfield.getPositionStart(), end);
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.log(Level.SEVERE, "Problem with processing 008 (\"{0}\"). The content length is only {1} while reading position @{2}-{3} (for {4} \"{5}\")", new Object[]{this.content, this.content.length(), subfield.getPositionStart(), subfield.getPositionEnd(), subfield.getId(), subfield.getLabel()});
            }
            controlValue = new ControlValue(subfield, value);
            this.registerControlValue(controlValue);
            switch (subfield.getId()) {
                case "008all00": {
                    this.tag008all00 = controlValue;
                    break;
                }
                case "008all06": {
                    this.tag008all06 = controlValue;
                    break;
                }
                case "008all07": {
                    this.tag008all07 = controlValue;
                    break;
                }
                case "008all11": {
                    this.tag008all11 = controlValue;
                    break;
                }
                case "008all15": {
                    this.tag008all15 = controlValue;
                    break;
                }
                case "008all35": {
                    this.tag008all35 = controlValue;
                    break;
                }
                case "008all38": {
                    this.tag008all38 = controlValue;
                    break;
                }
                case "008all39": {
                    this.tag008all39 = controlValue;
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "Unhandled 008 subfield: " + subfield.getId());
                }
            }
            this.valuesMap.put(subfield, value);
            this.byPosition.put(subfield.getPositionStart(), subfield);
        }
        for (ControlfieldPositionDefinition subfield : Control008Positions.getInstance().get(this.actual008Type)) {
            end = Math.min(this.content.length(), subfield.getPositionEnd());
            value = null;
            if (subfield.getPositionStart() > this.content.length()) break;
            try {
                value = this.content.substring(subfield.getPositionStart(), end);
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.log(Level.SEVERE, "Problem with processing 008 (\"{0}\"). The content length is only {1} while reading position @{2}-{3} (for {4} \"{5}\")", new Object[]{this.content, this.content.length(), subfield.getPositionStart(), subfield.getPositionEnd(), subfield.getId(), subfield.getLabel()});
            }
            controlValue = new ControlValue(subfield, value);
            this.registerControlValue(controlValue);
            block22 : switch (this.actual008Type) {
                case BOOKS: {
                    switch (subfield.getId()) {
                        case "008book18": {
                            this.tag008book18 = controlValue;
                            break block22;
                        }
                        case "008book22": {
                            this.tag008book22 = controlValue;
                            break block22;
                        }
                        case "008book23": {
                            this.tag008book23 = controlValue;
                            break block22;
                        }
                        case "008book24": {
                            this.tag008book24 = controlValue;
                            break block22;
                        }
                        case "008book28": {
                            this.tag008book28 = controlValue;
                            break block22;
                        }
                        case "008book29": {
                            this.tag008book29 = controlValue;
                            break block22;
                        }
                        case "008book30": {
                            this.tag008book30 = controlValue;
                            break block22;
                        }
                        case "008book31": {
                            this.tag008book31 = controlValue;
                            break block22;
                        }
                        case "008book33": {
                            this.tag008book33 = controlValue;
                            break block22;
                        }
                        case "008book34": {
                            this.tag008book34 = controlValue;
                            break block22;
                        }
                    }
                    logger.log(Level.SEVERE, "Unhandled 008 subfield: " + subfield.getId());
                    break;
                }
                case COMPUTER_FILES: {
                    switch (subfield.getId()) {
                        case "008computer22": {
                            this.tag008computer22 = controlValue;
                            break block22;
                        }
                        case "008computer23": {
                            this.tag008computer23 = controlValue;
                            break block22;
                        }
                        case "008computer26": {
                            this.tag008computer26 = controlValue;
                            break block22;
                        }
                        case "008computer28": {
                            this.tag008computer28 = controlValue;
                            break block22;
                        }
                    }
                    logger.log(Level.SEVERE, "Unhandled 008 subfield: " + subfield.getId());
                    break;
                }
                case MAPS: {
                    switch (subfield.getId()) {
                        case "008map18": {
                            this.tag008map18 = controlValue;
                            break block22;
                        }
                        case "008map22": {
                            this.tag008map22 = controlValue;
                            break block22;
                        }
                        case "008map25": {
                            this.tag008map25 = controlValue;
                            break block22;
                        }
                        case "008map28": {
                            this.tag008map28 = controlValue;
                            break block22;
                        }
                        case "008map29": {
                            this.tag008map29 = controlValue;
                            break block22;
                        }
                        case "008map31": {
                            this.tag008map31 = controlValue;
                            break block22;
                        }
                        case "008map33": {
                            this.tag008map33 = controlValue;
                            break block22;
                        }
                    }
                    logger.log(Level.SEVERE, "Unhandled 008 subfield: " + subfield.getId());
                    break;
                }
                case MUSIC: {
                    switch (subfield.getId()) {
                        case "008music18": {
                            this.tag008music18 = controlValue;
                            break block22;
                        }
                        case "008music20": {
                            this.tag008music20 = controlValue;
                            break block22;
                        }
                        case "008music21": {
                            this.tag008music21 = controlValue;
                            break block22;
                        }
                        case "008music22": {
                            this.tag008music22 = controlValue;
                            break block22;
                        }
                        case "008music23": {
                            this.tag008music23 = controlValue;
                            break block22;
                        }
                        case "008music24": {
                            this.tag008music24 = controlValue;
                            break block22;
                        }
                        case "008music30": {
                            this.tag008music30 = controlValue;
                            break block22;
                        }
                        case "008music33": {
                            this.tag008music33 = controlValue;
                            break block22;
                        }
                    }
                    logger.log(Level.SEVERE, "Unhandled 008 subfield: " + subfield.getId());
                    break;
                }
                case CONTINUING_RESOURCES: {
                    switch (subfield.getId()) {
                        case "008continuing18": {
                            this.tag008continuing18 = controlValue;
                            break block22;
                        }
                        case "008continuing19": {
                            this.tag008continuing19 = controlValue;
                            break block22;
                        }
                        case "008continuing21": {
                            this.tag008continuing21 = controlValue;
                            break block22;
                        }
                        case "008continuing22": {
                            this.tag008continuing22 = controlValue;
                            break block22;
                        }
                        case "008continuing23": {
                            this.tag008continuing23 = controlValue;
                            break block22;
                        }
                        case "008continuing24": {
                            this.tag008continuing24 = controlValue;
                            break block22;
                        }
                        case "008continuing25": {
                            this.tag008continuing25 = controlValue;
                            break block22;
                        }
                        case "008continuing28": {
                            this.tag008continuing28 = controlValue;
                            break block22;
                        }
                        case "008continuing29": {
                            this.tag008continuing29 = controlValue;
                            break block22;
                        }
                        case "008continuing33": {
                            this.tag008continuing33 = controlValue;
                            break block22;
                        }
                        case "008continuing34": {
                            this.tag008continuing34 = controlValue;
                            break block22;
                        }
                    }
                    logger.log(Level.SEVERE, "Unhandled 008 subfield: " + subfield.getId());
                    break;
                }
                case VISUAL_MATERIALS: {
                    switch (subfield.getId()) {
                        case "008visual18": {
                            this.tag008visual18 = controlValue;
                            break block22;
                        }
                        case "008visual22": {
                            this.tag008visual22 = controlValue;
                            break block22;
                        }
                        case "008visual28": {
                            this.tag008visual28 = controlValue;
                            break block22;
                        }
                        case "008visual29": {
                            this.tag008visual29 = controlValue;
                            break block22;
                        }
                        case "008visual33": {
                            this.tag008visual33 = controlValue;
                            break block22;
                        }
                        case "008visual34": {
                            this.tag008visual34 = controlValue;
                            break block22;
                        }
                    }
                    logger.log(Level.SEVERE, "Unhandled 008 subfield: " + subfield.getId());
                    break;
                }
                case MIXED_MATERIALS: {
                    if ("008mixed23".equals(subfield.getId())) {
                        this.tag008mixed23 = controlValue;
                        break;
                    }
                    logger.log(Level.SEVERE, "Unhandled 008 subfield: " + subfield.getId());
                }
            }
            this.valuesMap.put(subfield, value);
            this.byPosition.put(subfield.getPositionStart(), subfield);
        }
    }

    public String resolve(ControlfieldPositionDefinition key) {
        String value = (String)this.valuesMap.get(key);
        return key.resolve(value);
    }

    public String getValueByPosition(int position) {
        return (String)this.valuesMap.get(this.getSubfieldByPosition(position));
    }

    public ControlfieldPositionDefinition getSubfieldByPosition(int position) {
        return this.byPosition.get(position);
    }

    public Set<Integer> getSubfieldPositions() {
        return this.byPosition.keySet();
    }

    public Map<ControlfieldPositionDefinition, String> getValueMap() {
        return this.valuesMap;
    }

    public Leader.Type getRecordType() {
        return this.recordType;
    }

    public ControlValue getTag008all00() {
        return this.tag008all00;
    }

    public ControlValue getTag008all06() {
        return this.tag008all06;
    }

    public ControlValue getTag008all07() {
        return this.tag008all07;
    }

    public ControlValue getTag008all11() {
        return this.tag008all11;
    }

    public ControlValue getTag008all15() {
        return this.tag008all15;
    }

    public ControlValue getTag008all35() {
        return this.tag008all35;
    }

    public ControlValue getTag008all38() {
        return this.tag008all38;
    }

    public ControlValue getTag008all39() {
        return this.tag008all39;
    }

    public ControlValue getTag008book18() {
        return this.tag008book18;
    }

    public ControlValue getTag008book22() {
        return this.tag008book22;
    }

    public ControlValue getTag008book23() {
        return this.tag008book23;
    }

    public ControlValue getTag008book24() {
        return this.tag008book24;
    }

    public ControlValue getTag008book28() {
        return this.tag008book28;
    }

    public ControlValue getTag008book29() {
        return this.tag008book29;
    }

    public ControlValue getTag008book30() {
        return this.tag008book30;
    }

    public ControlValue getTag008book31() {
        return this.tag008book31;
    }

    public ControlValue getTag008book33() {
        return this.tag008book33;
    }

    public ControlValue getTag008book34() {
        return this.tag008book34;
    }

    public ControlValue getTag008computer22() {
        return this.tag008computer22;
    }

    public ControlValue getTag008computer23() {
        return this.tag008computer23;
    }

    public ControlValue getTag008computer26() {
        return this.tag008computer26;
    }

    public ControlValue getTag008computer28() {
        return this.tag008computer28;
    }

    public ControlValue getTag008map18() {
        return this.tag008map18;
    }

    public ControlValue getTag008map22() {
        return this.tag008map22;
    }

    public ControlValue getTag008map25() {
        return this.tag008map25;
    }

    public ControlValue getTag008map28() {
        return this.tag008map28;
    }

    public ControlValue getTag008map29() {
        return this.tag008map29;
    }

    public ControlValue getTag008map31() {
        return this.tag008map31;
    }

    public ControlValue getTag008map33() {
        return this.tag008map33;
    }

    public ControlValue getTag008music18() {
        return this.tag008music18;
    }

    public ControlValue getTag008music20() {
        return this.tag008music20;
    }

    public ControlValue getTag008music21() {
        return this.tag008music21;
    }

    public ControlValue getTag008music22() {
        return this.tag008music22;
    }

    public ControlValue getTag008music23() {
        return this.tag008music23;
    }

    public ControlValue getTag008music24() {
        return this.tag008music24;
    }

    public ControlValue getTag008music30() {
        return this.tag008music30;
    }

    public ControlValue getTag008music33() {
        return this.tag008music33;
    }

    public ControlValue getTag008continuing18() {
        return this.tag008continuing18;
    }

    public ControlValue getTag008continuing19() {
        return this.tag008continuing19;
    }

    public ControlValue getTag008continuing21() {
        return this.tag008continuing21;
    }

    public ControlValue getTag008continuing22() {
        return this.tag008continuing22;
    }

    public ControlValue getTag008continuing23() {
        return this.tag008continuing23;
    }

    public ControlValue getTag008continuing24() {
        return this.tag008continuing24;
    }

    public ControlValue getTag008continuing25() {
        return this.tag008continuing25;
    }

    public ControlValue getTag008continuing28() {
        return this.tag008continuing28;
    }

    public ControlValue getTag008continuing29() {
        return this.tag008continuing29;
    }

    public ControlValue getTag008continuing33() {
        return this.tag008continuing33;
    }

    public ControlValue getTag008continuing34() {
        return this.tag008continuing34;
    }

    public ControlValue getTag008visual18() {
        return this.tag008visual18;
    }

    public ControlValue getTag008visual22() {
        return this.tag008visual22;
    }

    public ControlValue getTag008visual28() {
        return this.tag008visual28;
    }

    public ControlValue getTag008visual29() {
        return this.tag008visual29;
    }

    public ControlValue getTag008visual33() {
        return this.tag008visual33;
    }

    public ControlValue getTag008visual34() {
        return this.tag008visual34;
    }

    public ControlValue getTag008mixed23() {
        return this.tag008mixed23;
    }
}

