/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.dao;

import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.dao.SimpleControlField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.tags.control.Control005Definition;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Control005
extends SimpleControlField
implements Extractable {
    private static final Logger logger = Logger.getLogger(Control005.class.getCanonicalName());
    private static final Pattern DATE_TIME = Pattern.compile("^(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})\\.(\\d)$");
    private static final Pattern DATE_ONLY = Pattern.compile("^(\\d{4})(\\d{2})(\\d{2})([\\d ]{2})([\\d ]{2})([\\d ]{2})  $");
    private Integer year;
    private Integer month;
    private Integer day;
    private Integer hour;
    private Integer min;
    private Integer sec;
    private Integer ms;

    public Control005(String content) {
        super(Control005Definition.getInstance(), content);
        this.processContent();
    }

    public Control005(String content, BibliographicRecord marcRecord) {
        super(Control005Definition.getInstance(), content);
        this.marcRecord = marcRecord;
        this.processContent();
    }

    protected void processContent() {
        Matcher matcher = DATE_TIME.matcher(this.content);
        if (matcher.matches()) {
            this.year = Integer.parseInt(matcher.group(1));
            this.month = Integer.parseInt(matcher.group(2));
            this.day = Integer.parseInt(matcher.group(3));
            this.hour = Integer.parseInt(matcher.group(4));
            this.min = Integer.parseInt(matcher.group(5));
            this.sec = Integer.parseInt(matcher.group(6));
            this.ms = Integer.parseInt(matcher.group(7));
        } else {
            this.initializationErrors.add(this.createError("The field value does not match the expected pattern"));
            matcher = DATE_ONLY.matcher(this.content);
            if (matcher.matches()) {
                this.year = Integer.parseInt(matcher.group(1));
                this.month = Integer.parseInt(matcher.group(2));
                this.day = Integer.parseInt(matcher.group(3));
                if (StringUtils.isNumeric((CharSequence)matcher.group(4))) {
                    this.hour = Integer.parseInt(matcher.group(4));
                }
                if (StringUtils.isNumeric((CharSequence)matcher.group(5))) {
                    this.min = Integer.parseInt(matcher.group(5));
                }
                if (StringUtils.isNumeric((CharSequence)matcher.group(6))) {
                    this.sec = Integer.parseInt(matcher.group(6));
                }
            } else {
                String cleanContent = this.content.replaceAll("[\\. ]{1,10}$", "").replaceAll("\\.", "");
                if (cleanContent.length() >= 4) {
                    this.year = this.extractRaw(cleanContent, 4, "year");
                    cleanContent = cleanContent.substring(4);
                }
                if (cleanContent.length() >= 2) {
                    this.month = this.extractRaw(cleanContent, 2, "month");
                    cleanContent = cleanContent.substring(2);
                }
                if (cleanContent.length() >= 2) {
                    this.day = this.extractRaw(cleanContent, 2, "day");
                    cleanContent = cleanContent.substring(2);
                }
                if (cleanContent.length() >= 2) {
                    this.hour = this.extractRaw(cleanContent, 2, "hour");
                    cleanContent = cleanContent.substring(2);
                }
                if (cleanContent.length() >= 2) {
                    this.min = this.extractRaw(cleanContent, 2, "min");
                    cleanContent = cleanContent.substring(2);
                }
                if (cleanContent.length() >= 2) {
                    this.sec = this.extractRaw(cleanContent, 2, "sec");
                    String string = cleanContent.substring(2);
                }
            }
        }
    }

    private Integer extractRaw(String cleanContent, int end, String field) {
        String text = cleanContent.substring(0, end);
        Integer data = null;
        try {
            data = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            String id = this.marcRecord != null ? String.format("#%s) ", this.marcRecord.getId()) : "";
            logger.log(Level.SEVERE, "{0}Bad input for {1}: {2}", new Object[]{id, field, text});
            this.initializationErrors.add(this.createError(String.format("invalid %s: %s", field, text)));
        }
        return data;
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        this.validationErrors = new ArrayList();
        if (!this.initializationErrors.isEmpty()) {
            this.validationErrors.addAll(this.initializationErrors);
        }
        return this.isValidMonth() && this.isValidDay() && this.isValidHour() && this.isValidMin() && this.isValidSec();
    }

    private boolean isValidMonth() {
        boolean valid;
        boolean bl = valid = this.month != null && this.month >= 1 && this.month <= 12;
        if (!valid) {
            this.addError(String.format("invalid month: %d", this.month));
        }
        return valid;
    }

    private boolean isValidDay() {
        boolean valid;
        boolean bl = valid = this.day != null && this.day >= 1 && this.day <= 31;
        if (!valid) {
            this.addError(String.format("invalid day: %d", this.day));
        }
        return valid;
    }

    private boolean isValidHour() {
        boolean valid;
        boolean bl = valid = this.hour != null && this.hour >= 0 && this.hour <= 23;
        if (!valid) {
            this.addError(String.format("invalid hour: %d", this.hour));
        }
        return valid;
    }

    private boolean isValidMin() {
        boolean valid;
        boolean bl = valid = this.min != null && this.min >= 0 && this.min <= 59;
        if (!valid) {
            this.addError(String.format("invalid minute: %d", this.min));
        }
        return valid;
    }

    private boolean isValidSec() {
        boolean valid;
        boolean bl = valid = this.sec != null && this.sec >= 0 && this.sec <= 59;
        if (!valid) {
            this.addError(String.format("invalid second: %d", this.sec));
        }
        return valid;
    }

    public Integer getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getDay() {
        return this.day;
    }

    public Integer getHour() {
        return this.hour;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getSec() {
        return this.sec;
    }

    public Integer getMs() {
        return this.ms;
    }

    private void addError(String msg) {
        this.validationErrors.add(this.createError(msg));
    }

    private ValidationError createError(String msg) {
        String id = this.marcRecord != null ? this.marcRecord.getId() : null;
        return new ValidationError(id, this.definition.getTag(), ValidationErrorType.CONTROL_POSITION_INVALID_VALUE, String.format("%s in '%s'", msg, this.content), this.definition.getDescriptionUrl());
    }

    public String toString() {
        return "Control005{content='" + this.content + "'}";
    }
}

