/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils.ignorablerecords;

import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.CriteriumPica;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.Operator;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.utils.parser.BooleanContainer;
import de.gwdg.metadataqa.marc.utils.parser.BooleanParser;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaPath;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaPathParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PicaFilter {
    protected static final Pattern CRITERIUM = Pattern.compile("^([012\\.][A-Za-z0-9@\\./\\$\\*\\-]+?)(\\s*(==|!=|=~|!~|=\\^|=\\$)\\s*(?:'([^']+)'|\"([^\"]+)\")|\\?)$");
    protected List<CriteriumPica> criteria = new ArrayList<CriteriumPica>();
    protected BooleanContainer<CriteriumPica> booleanCriteria;

    protected void parse(String ignorableRecordsInput) {
        if (StringUtils.isNotBlank((CharSequence)ignorableRecordsInput)) {
            this.booleanCriteria = this.transformContainer(BooleanParser.parse(ignorableRecordsInput));
        }
    }

    private BooleanContainer<CriteriumPica> transformContainer(BooleanContainer<String> booleanCriteria) {
        BooleanContainer<CriteriumPica> container = new BooleanContainer<CriteriumPica>();
        container.setOp(booleanCriteria.getOp());
        if (booleanCriteria.getValue() != null) {
            container.setValue(this.parseCriterium(booleanCriteria.getValue()));
        } else if (!booleanCriteria.getChildren().isEmpty()) {
            for (BooleanContainer<String> child : booleanCriteria.getChildren()) {
                container.getChildren().add(this.transformContainer(child));
            }
        }
        return container;
    }

    protected CriteriumPica parseCriterium(String rawCriterium) {
        Matcher m = CRITERIUM.matcher(rawCriterium);
        if (m.matches()) {
            String rawOp;
            String rawPath = m.group(1);
            String value = null;
            if (m.group(2).equals("?")) {
                rawOp = m.group(2);
            } else {
                rawOp = m.group(3);
                if (m.group(4) != null) {
                    value = m.group(4);
                } else if (m.group(5) != null) {
                    value = m.group(5);
                }
            }
            PicaPath p = PicaPathParser.parse(rawPath);
            Operator op = Operator.byCode(rawOp);
            return new CriteriumPica(p, op, value);
        }
        throw new IllegalArgumentException(String.format("The criterium does not fit to rules: '%s'", rawCriterium));
    }

    public List<CriteriumPica> getCriteria() {
        return this.criteria;
    }

    public BooleanContainer<CriteriumPica> getBooleanCriteria() {
        return this.booleanCriteria;
    }

    public boolean metCriteria(BibliographicRecord marcRecord, BooleanContainer<CriteriumPica> criteria) {
        boolean passed = false;
        if (criteria.getValue() != null) {
            passed = criteria.getValue().met(marcRecord);
        } else {
            boolean hasPassed = false;
            boolean hasFailed = false;
            for (BooleanContainer<CriteriumPica> container : criteria.getChildren()) {
                boolean p = this.metCriteria(marcRecord, container);
                if (p && !hasPassed) {
                    hasPassed = true;
                }
                if (!p && !hasFailed) {
                    hasFailed = true;
                }
                if ((!criteria.hasAnd() || p) && (!criteria.hasOr() || !p)) continue;
                break;
            }
            if (criteria.hasOr()) {
                passed = hasPassed;
            } else if (criteria.hasAnd()) {
                passed = hasPassed && !hasFailed;
            }
        }
        return passed;
    }

    public String toString() {
        return "PicaFilter{criteria=" + this.booleanCriteria + "}";
    }
}

