/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.NetworkAction;
import java.io.Serializable;
import org.apache.commons.cli.ParseException;

public class NetworkParameters
extends CommonParameters
implements Serializable {
    public static final String DEFAULT_FILE_NAME = "validation-report.txt";
    private NetworkAction action = NetworkAction.PRIMARY;
    private int groupLimit = 1000;
    private boolean isOptionSet;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("a", "action", true, "action: 'primary' (default), 'pairing'");
            this.options.addOption("l", "group-limit", true, "pair creation limit");
            this.isOptionSet = true;
        }
    }

    public NetworkParameters() {
    }

    public NetworkParameters(String[] arguments) throws ParseException {
        super(arguments);
        if (this.cmd.hasOption("action")) {
            for (NetworkAction registeredAction : NetworkAction.values()) {
                if (!registeredAction.getLabel().equals(this.cmd.getOptionValue("action"))) continue;
                this.action = registeredAction;
                break;
            }
        }
        if (this.cmd.hasOption("group-limit")) {
            this.groupLimit = Integer.parseInt(this.cmd.getOptionValue("group-limit"));
        }
    }

    public NetworkAction getAction() {
        return this.action;
    }

    public int getGroupLimit() {
        return this.groupLimit;
    }

    @Override
    public String formatParameters() {
        Object text = super.formatParameters();
        text = (String)text + String.format("action: %s%n", new Object[]{this.action});
        text = (String)text + String.format("group-limit: %d%n", this.groupLimit);
        return text;
    }
}

