/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.model.SolrFieldType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MappingParameters {
    private boolean exportSubfieldCodes = false;
    private boolean exportSelfDescriptiveCodes = false;
    private boolean exportFrbrFunctions = false;
    private boolean exportCompilanceLevel = false;
    private boolean withLocallyDefinedFields = false;
    private SolrFieldType solrFieldType = SolrFieldType.MARC;
    protected Options options = new Options();
    protected static final CommandLineParser parser = new DefaultParser();
    protected CommandLine cmd;
    private boolean isOptionSet = false;

    protected void setOptions() {
        if (!this.isOptionSet) {
            this.options.addOption("c", "withSubfieldCodelists", false, "with subfield codelists");
            this.options.addOption("s", "withSelfDescriptiveCode", false, "with self-descriptive codes");
            this.options.addOption("t", "solrFieldType", true, "type of Solr fields, could be one of 'marc-tags', 'human-readable', or 'mixed'");
            this.options.addOption("f", "withFrbrFunctions", false, "with FRBR functions");
            this.options.addOption("l", "withComplianceLevel", false, "with compilance levels (national, minimal)");
            this.options.addOption("d", "withLocallyDefinedFields", false, "with locally defined fields");
            this.options.addOption("h", "help", false, "display help");
            this.isOptionSet = true;
        }
    }

    public MappingParameters() {
    }

    public MappingParameters(String[] arguments) throws ParseException {
        this.cmd = parser.parse(this.getOptions(), arguments);
        if (this.cmd.hasOption("withSubfieldCodelists")) {
            this.exportSubfieldCodes = true;
        }
        if (this.cmd.hasOption("withSelfDescriptiveCode")) {
            this.exportSelfDescriptiveCodes = true;
        }
        if (this.cmd.hasOption("solrFieldType")) {
            this.solrFieldType = SolrFieldType.byCode(this.cmd.getOptionValue("solrFieldType"));
        }
        if (this.cmd.hasOption("withFrbrFunctions")) {
            this.exportFrbrFunctions = true;
        }
        if (this.cmd.hasOption("withComplianceLevel")) {
            this.exportCompilanceLevel = true;
        }
        if (this.cmd.hasOption("withLocallyDefinedFields")) {
            this.withLocallyDefinedFields = true;
        }
    }

    public Options getOptions() {
        if (!this.isOptionSet) {
            this.setOptions();
        }
        return this.options;
    }

    public boolean doExportSubfieldCodes() {
        return this.exportSubfieldCodes;
    }

    public boolean doExportSelfDescriptiveCodes() {
        return this.exportSelfDescriptiveCodes;
    }

    public SolrFieldType getSolrFieldType() {
        return this.solrFieldType;
    }

    public boolean doExportFrbrFunctions() {
        return this.exportFrbrFunctions;
    }

    public boolean doExportCompilanceLevel() {
        return this.exportCompilanceLevel;
    }

    public boolean isWithLocallyDefinedFields() {
        return this.withLocallyDefinedFields;
    }
}

