/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import java.io.Serializable;
import org.apache.commons.cli.ParseException;

public class CompletenessParameters
extends CommonParameters
implements Serializable {
    private ValidationErrorFormat format = ValidationErrorFormat.COMMA_SEPARATED;
    private boolean advanced = false;
    private boolean onlyPackages = false;
    private boolean isOptionSet;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("r", "format", true, "specify a format");
            this.options.addOption("v", "advanced", false, "advanced mode");
            this.options.addOption("p", "onlyPackages", false, "only packages");
            this.isOptionSet = true;
        }
    }

    public CompletenessParameters() {
    }

    public CompletenessParameters(String[] arguments) throws ParseException {
        super(arguments);
        if (this.cmd.hasOption("advanced")) {
            this.advanced = true;
        }
        if (this.cmd.hasOption("onlyPackages")) {
            this.onlyPackages = true;
        }
        if (this.cmd.hasOption("format")) {
            for (ValidationErrorFormat registeredFormat : ValidationErrorFormat.values()) {
                if (!registeredFormat.getNames().contains(this.cmd.getOptionValue("format"))) continue;
                this.format = registeredFormat;
                break;
            }
        }
    }

    public ValidationErrorFormat getFormat() {
        return this.format;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isOnlyPackages() {
        return this.onlyPackages;
    }

    @Override
    public String formatParameters() {
        Object text = super.formatParameters();
        text = (String)text + String.format("format: %s%n", this.format.getLabel());
        text = (String)text + String.format("advanced: %s%n", this.advanced);
        return text;
    }
}

