/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.CsvUtils;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.validator.Validator;
import de.gwdg.metadataqa.marc.analysis.validator.ValidatorConfiguration;
import de.gwdg.metadataqa.marc.analysis.validator.ValidatorDAO;
import de.gwdg.metadataqa.marc.cli.QACli;
import de.gwdg.metadataqa.marc.cli.parameters.ValidatorParameters;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorCategory;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormatter;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class ValidatorCli
extends QACli
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(ValidatorCli.class.getCanonicalName());
    private Options options;
    private final ValidatorParameters parameters;
    private final Map<Integer, Integer> hashedIndex = new HashMap<Integer, Integer>();
    private File detailsFile = null;
    private File summaryFile = null;
    private File collectorFile = null;
    private boolean doPrintInProcessRecord = true;
    private boolean readyToProcess;
    private int counter;
    private int numberOfprocessedRecords;
    private char separator;
    private boolean hasSeparator = false;
    private int vErrorId = 1;
    private List<ValidationError> allValidationErrors;
    private ValidatorConfiguration validatorConfiguration;
    private ValidatorDAO validatorDAO = new ValidatorDAO();

    public ValidatorCli(String[] args) throws ParseException {
        this(new ValidatorParameters(args));
    }

    public ValidatorCli(ValidatorParameters parameters) {
        this.parameters = parameters;
        this.options = parameters.getOptions();
        this.readyToProcess = true;
        this.counter = 0;
        this.validatorConfiguration = new ValidatorConfiguration().withMarcVersion(parameters.getMarcVersion()).withDoSummary(parameters.doSummary()).withIgnorableFields(parameters.getIgnorableFields()).withIgnorableIssueTypes(parameters.getIgnorableIssueTypes()).withSchemaType(parameters.getSchemaType());
        this.initializeGroups(parameters.getGroupBy(), parameters.isPica());
        if (this.doGroups()) {
            this.initializeMeta(parameters);
            if (this.doSaveGroupIds) {
                logger.info("saveGroupIds!");
                this.idCollectorFile = this.prepareReportFile(parameters.getOutputDir(), "id-groupid.csv");
                this.printToFile(this.idCollectorFile, CsvUtils.createCsv("id", "groupId"));
            }
        }
    }

    public static void main(String[] args) {
        ValidatorCli processor = null;
        try {
            processor = new ValidatorCli(args);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public void printHelp(Options opions) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp qa-catalogue.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, this.options);
    }

    @Override
    public ValidatorParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void beforeIteration() {
        String header;
        logger.info(this.parameters.formatParameters());
        if (!this.parameters.useStandardOutput()) {
            this.detailsFile = this.prepareReportFile(this.parameters.getOutputDir(), this.parameters.getDetailsFileName());
            logger.info("details output: " + this.detailsFile.getPath());
            if (this.parameters.getSummaryFileName() != null) {
                this.summaryFile = this.prepareReportFile(this.parameters.getOutputDir(), this.parameters.getSummaryFileName());
                logger.info("summary output: " + this.summaryFile.getPath());
                this.collectorFile = this.prepareReportFile(this.parameters.getOutputDir(), "issue-collector.csv");
                header = ValidationErrorFormatter.formatHeaderForCollector(this.parameters.getFormat());
                this.print(this.collectorFile, header);
            } else if (this.parameters.doSummary()) {
                this.summaryFile = this.detailsFile;
            }
        }
        if (this.parameters.doDetails()) {
            header = ValidationErrorFormatter.formatHeaderForDetails(this.parameters.getFormat());
            this.print(this.detailsFile, header);
        }
        if (this.parameters.collectAllErrors()) {
            this.allValidationErrors = new ArrayList<ValidationError>();
        }
        this.saveParameters("validation.params.json", this.parameters);
    }

    @Override
    public void fileOpened(Path currentFile) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(BibliographicRecord bibliographicRecord, int i) {
        Validator validator;
        boolean isValid;
        if (bibliographicRecord.getId() == null) {
            logger.severe("No record number at " + i);
        }
        if (i % 100000 == 0) {
            logger.info("Number of error types so far: " + this.validatorDAO.getInstanceBasedErrorCounter().size());
        }
        if (this.parameters.getRecordIgnorator().isIgnorable(bibliographicRecord)) {
            logger.info("skip " + bibliographicRecord.getId() + " (ignorable record)");
            return;
        }
        Set<String> groupIds = this.getGroupIds(this.parameters, bibliographicRecord);
        if (this.doSaveGroupIds) {
            this.saveGroupIds(bibliographicRecord.getId(true), groupIds);
        }
        if (!(isValid = (validator = new Validator(this.validatorConfiguration)).validate(bibliographicRecord)) && this.doPrintInProcessRecord) {
            if (this.parameters.doSummary()) {
                this.processSummary(bibliographicRecord, validator, groupIds);
            }
            if (this.parameters.doDetails()) {
                this.processDetails(bibliographicRecord, validator);
            }
        } else if (this.parameters.doSummary()) {
            this.updateCounters(0, groupIds, this.validatorDAO.getTotalRecordCounter(), this.validatorDAO.getTotalRecordCounterGrouped());
        }
        if (this.parameters.collectAllErrors()) {
            this.allValidationErrors.addAll(validator.getValidationErrors());
        }
        ++this.counter;
    }

    private void processDetails(BibliographicRecord marcRecord, Validator validator) {
        List<ValidationError> errors = validator.getValidationErrors();
        if (!errors.isEmpty()) {
            String message = null;
            if (this.parameters.doSummary()) {
                HashMap<Integer, Integer> errorIds = new HashMap<Integer, Integer>();
                for (ValidationError error : errors) {
                    if (error.getId() == null) {
                        error.setId(this.hashedIndex.get(error.hashCode()));
                    }
                    Utils.count(error.getId(), errorIds);
                }
                message = ValidationErrorFormatter.formatSimple(marcRecord.getId(this.parameters.getTrimId()), this.parameters.getFormat(), errorIds);
            } else {
                message = ValidationErrorFormatter.format(errors, this.parameters.getFormat(), this.parameters.getTrimId());
            }
            if (message != null) {
                this.print(this.detailsFile, message);
            }
        }
    }

    private void processSummary(BibliographicRecord marcRecord, Validator validator) {
        this.processSummary(marcRecord, validator, null);
    }

    private void processSummary(BibliographicRecord marcRecord, Validator validator, Set<String> groupIds) {
        List<ValidationError> errors = validator.getValidationErrors();
        ArrayList<ValidationError> allButInvalidFieldErrors = new ArrayList<ValidationError>();
        HashSet<Integer> uniqueErrors = new HashSet<Integer>();
        HashSet<ValidationErrorType> uniqueTypes = new HashSet<ValidationErrorType>();
        HashSet<ValidationErrorCategory> uniqueCategories = new HashSet<ValidationErrorCategory>();
        for (ValidationError error : errors) {
            if (!this.validatorDAO.getInstanceBasedErrorCounter().containsKey(error)) {
                error.setId(this.vErrorId++);
                this.hashedIndex.put(error.hashCode(), error.getId());
            } else {
                error.setId(this.hashedIndex.get(error.hashCode()));
            }
            if (!error.getType().equals((Object)ValidationErrorType.FIELD_UNDEFINED)) {
                Utils.count(2, this.validatorDAO.getTotalInstanceCounter());
                allButInvalidFieldErrors.add(error);
            }
            Utils.count(error, this.validatorDAO.getInstanceBasedErrorCounter());
            for (String groupId : groupIds) {
                this.validatorDAO.getInstanceBasedErrorCounterGrouped().computeIfAbsent(groupId, s -> new HashMap());
                Utils.count(error, this.validatorDAO.getInstanceBasedErrorCounterGrouped().get(groupId));
            }
            this.updateCounters(error.getType(), groupIds, this.validatorDAO.getTypeInstanceCounter(), this.validatorDAO.getTypeInstanceCounterGrouped());
            this.updateCounters(error.getType().getCategory(), groupIds, this.validatorDAO.getCategoryInstanceCounter(), this.validatorDAO.getCategoryInstanceCounterGrouped());
            Utils.count(1, this.validatorDAO.getTotalInstanceCounter());
            this.updateErrorCollector(marcRecord.getId(true), error.getId());
            uniqueErrors.add(error.getId());
            uniqueTypes.add(error.getType());
            uniqueCategories.add(error.getType().getCategory());
        }
        for (Integer errorId : uniqueErrors) {
            this.updateCounters(errorId, groupIds, this.validatorDAO.getRecordBasedErrorCounter(), this.validatorDAO.getRecordBasedErrorCounterGrouped());
        }
        for (ValidationErrorType errorType : uniqueTypes) {
            this.updateCounters(errorType, groupIds, this.validatorDAO.getTypeRecordCounter(), this.validatorDAO.getTypeRecordCounterGrouped());
        }
        for (ValidationErrorCategory errorCategory : uniqueCategories) {
            this.updateCounters(errorCategory, groupIds, this.validatorDAO.getCategoryRecordCounter(), this.validatorDAO.getCategoryRecordCounterGrouped());
        }
        this.updateCounters(1, groupIds, this.validatorDAO.getTotalRecordCounter(), this.validatorDAO.getTotalRecordCounterGrouped());
        if (!allButInvalidFieldErrors.isEmpty()) {
            this.updateCounters(2, groupIds, this.validatorDAO.getTotalRecordCounter(), this.validatorDAO.getTotalRecordCounterGrouped());
        }
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        logger.info("printCounter");
        this.numberOfprocessedRecords = numberOfprocessedRecords;
        this.printCounter();
        char separator = this.getSeparator();
        if (this.parameters.doSummary()) {
            if (this.doGroups()) {
                this.printSummaryGrouped(separator);
                this.printCategoryCountsGrouped();
                this.printTypeCountsGrouped();
                this.printTotalCountsGrouped();
            } else {
                this.printSummary(separator);
                this.printCategoryCounts();
                this.printTypeCounts();
                this.printTotalCounts();
            }
            this.printCollector();
        }
        this.copySchemaFileToOutputDir();
        logger.info("all printing is DONE");
    }

    private void copySchemaFileToOutputDir() {
        if (this.parameters.isPica()) {
            String schemaFile = StringUtils.isNotEmpty((CharSequence)this.parameters.getPicaSchemaFile()) ? this.parameters.getPicaSchemaFile() : Paths.get("src/main/resources/pica/avram-k10plus-title.json", new String[0]).toAbsolutePath().toString();
            File source = new File(schemaFile);
            try {
                FileUtils.copyFileToDirectory((File)source, (File)new File(this.parameters.getOutputDir()));
            }
            catch (IOException e) {
                logger.warning(e.getLocalizedMessage());
            }
        }
    }

    private void printCounter() {
        File countFile = this.prepareReportFile(this.parameters.getOutputDir(), "count.csv");
        if (this.parameters.getRecordIgnorator().isEmpty()) {
            this.printToFile(countFile, "total\n");
            this.printToFile(countFile, String.valueOf(this.numberOfprocessedRecords) + "\n");
        } else {
            this.printToFile(countFile, StringUtils.join(Arrays.asList("total", "processed"), (String)",") + "\n");
            this.printToFile(countFile, StringUtils.join(Arrays.asList(this.numberOfprocessedRecords, this.counter), (String)",") + "\n");
        }
    }

    private void printCollector() {
        for (Map.Entry<Integer, Set<String>> entry : this.validatorDAO.getErrorCollector().entrySet()) {
            this.printCollectorEntry(entry.getKey(), entry.getValue());
        }
    }

    private void printSummary(char separator) {
        String header = ValidationErrorFormatter.formatHeaderForSummary(this.parameters.getFormat(), this.doGroups());
        this.print(this.summaryFile, header);
        this.validatorDAO.getInstanceBasedErrorCounter().entrySet().stream().sorted((a, b) -> {
            Integer typeIdB;
            Integer typeIdA = ((ValidationError)a.getKey()).getType().getId();
            int result = typeIdA.compareTo(typeIdB = Integer.valueOf(((ValidationError)b.getKey()).getType().getId()));
            if (result == 0) {
                Integer recordCountA = this.validatorDAO.getRecordBasedErrorCounter().get(((ValidationError)a.getKey()).getId());
                Integer recordCountB = this.validatorDAO.getRecordBasedErrorCounter().get(((ValidationError)b.getKey()).getId());
                result = recordCountB.compareTo(recordCountA);
            }
            return result;
        }).forEach(entry -> {
            ValidationError error = (ValidationError)entry.getKey();
            int instanceCount = (Integer)entry.getValue();
            ArrayList<Object> cells = new ArrayList<Object>();
            cells.add(error.getId());
            cells.addAll(Arrays.asList(ValidationErrorFormatter.asArrayWithoutId(error)));
            cells.addAll(Arrays.asList(instanceCount, this.validatorDAO.getRecordBasedErrorCounter().get(error.getId())));
            this.print(this.summaryFile, CsvUtils.createCsv(cells));
        });
    }

    private void printSummaryGrouped(char separator) {
        String header = ValidationErrorFormatter.formatHeaderForSummary(this.parameters.getFormat(), this.doGroups());
        this.print(this.summaryFile, header);
        this.validatorDAO.getInstanceBasedErrorCounterGrouped().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(groupEntry -> {
            String groupId = (String)groupEntry.getKey();
            Map groupMap = (Map)groupEntry.getValue();
            groupMap.entrySet().stream().sorted((a, b) -> {
                Integer typeIdB;
                Integer typeIdA = ((ValidationError)a.getKey()).getType().getId();
                int result = typeIdA.compareTo(typeIdB = Integer.valueOf(((ValidationError)b.getKey()).getType().getId()));
                if (result == 0) {
                    Integer recordCountA = this.validatorDAO.getRecordBasedErrorCounterGrouped().get(groupId).get(((ValidationError)a.getKey()).getId());
                    Integer recordCountB = this.validatorDAO.getRecordBasedErrorCounterGrouped().get(groupId).get(((ValidationError)b.getKey()).getId());
                    result = recordCountB.compareTo(recordCountA);
                }
                return result;
            }).forEach(entry -> {
                ValidationError error = (ValidationError)entry.getKey();
                int instanceCount = (Integer)entry.getValue();
                ArrayList<Object> cells = new ArrayList<Object>();
                cells.add(groupId);
                cells.add(error.getId());
                cells.addAll(Arrays.asList(ValidationErrorFormatter.asArrayWithoutId(error)));
                cells.addAll(Arrays.asList(instanceCount, this.validatorDAO.getRecordBasedErrorCounterGrouped().get(groupId).get(error.getId())));
                this.print(this.summaryFile, CsvUtils.createCsv(cells));
            });
        });
    }

    private void printTypeCounts() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-by-type.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("id", "categoryId", "category", "type", "instances", "records"));
            this.validatorDAO.getTypeRecordCounter().entrySet().stream().sorted(Comparator.comparing(a -> ((ValidationErrorType)((Object)((Object)a.getKey()))).getId())).forEach(entry -> {
                ValidationErrorType type = (ValidationErrorType)((Object)((Object)entry.getKey()));
                int records = (Integer)entry.getValue();
                int instances = this.validatorDAO.getTypeInstanceCounter().get(entry.getKey());
                try {
                    writer.write(CsvUtils.createCsv(type.getId(), type.getCategory().getId(), type.getCategory().getName(), type.getMessage(), instances, records));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "printTypeCounts", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printTypeCounts", e);
        }
    }

    private void printTypeCountsGrouped() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-by-type.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("groupId", "id", "categoryId", "category", "type", "instances", "records"));
            this.validatorDAO.getTypeRecordCounterGrouped().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(groupEntry -> {
                String groupId = (String)groupEntry.getKey();
                Map groupMap = (Map)groupEntry.getValue();
                groupMap.entrySet().stream().sorted(Comparator.comparing(a -> ((ValidationErrorType)((Object)((Object)((Object)a.getKey())))).getId())).forEach(entry -> {
                    ValidationErrorType type = (ValidationErrorType)((Object)((Object)((Object)entry.getKey())));
                    int records = (Integer)entry.getValue();
                    int instances = this.validatorDAO.getTypeInstanceCounterGrouped().get(groupId).get(entry.getKey());
                    try {
                        writer.write(CsvUtils.createCsv(groupId, type.getId(), type.getCategory().getId(), type.getCategory().getName(), type.getMessage(), instances, records));
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "printTypeCounts", e);
                    }
                });
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printTypeCounts", e);
        }
    }

    private void printTotalCounts() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-total.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("type", "instances", "records"));
            this.validatorDAO.getTotalRecordCounter().entrySet().stream().forEach(entry -> {
                int records = (Integer)entry.getValue();
                int instances = this.validatorDAO.getTotalInstanceCounter().getOrDefault(entry.getKey(), 0);
                try {
                    writer.write(CsvUtils.createCsv(entry.getKey(), instances, records));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "printTotalCounts", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printTotalCounts", e);
        }
    }

    private void printTotalCountsGrouped() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-total.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("groupId", "type", "instances", "records"));
            this.validatorDAO.getTotalRecordCounterGrouped().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(groupEntry -> {
                String groupId = (String)groupEntry.getKey();
                Map groupMap = (Map)groupEntry.getValue();
                groupMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(entry -> {
                    int type = (Integer)entry.getKey();
                    int records = (Integer)entry.getValue();
                    int instances = this.validatorDAO.getTotalInstanceCounter().getOrDefault(type, 0);
                    try {
                        writer.write(CsvUtils.createCsv(groupId, type, instances, records));
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "printTotalCounts", e);
                    }
                });
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printTotalCounts", e);
        }
    }

    private void printCategoryCounts() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-by-category.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("id", "category", "instances", "records"));
            this.validatorDAO.getCategoryRecordCounter().entrySet().stream().sorted((a, b) -> Integer.valueOf(((ValidationErrorCategory)((Object)((Object)a.getKey()))).getId()).compareTo(((ValidationErrorCategory)((Object)((Object)b.getKey()))).getId())).forEach(entry -> {
                ValidationErrorCategory category = (ValidationErrorCategory)((Object)((Object)entry.getKey()));
                int records = (Integer)entry.getValue();
                int instances = this.validatorDAO.getCategoryInstanceCounter().getOrDefault(entry.getKey(), -1);
                try {
                    writer.write(CsvUtils.createCsv(category.getId(), category.getName(), instances, records));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "printCategoryCounts", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printCategoryCounts", e);
        }
    }

    private void printCategoryCountsGrouped() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-by-category.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("groupId", "id", "category", "instances", "records"));
            this.validatorDAO.getCategoryRecordCounterGrouped().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(groupEntry -> {
                String groupId = (String)groupEntry.getKey();
                Map groupMap = (Map)groupEntry.getValue();
                groupMap.entrySet().stream().sorted(Comparator.comparing(a -> ((ValidationErrorCategory)((Object)((Object)((Object)a.getKey())))).getId())).forEach(entry -> {
                    ValidationErrorCategory category = (ValidationErrorCategory)((Object)((Object)((Object)entry.getKey())));
                    int records = (Integer)entry.getValue();
                    int instances = this.validatorDAO.getCategoryInstanceCounterGrouped().get(groupId).getOrDefault(entry.getKey(), -1);
                    try {
                        writer.write(CsvUtils.createCsv(groupId, category.getId(), category.getName(), instances, records));
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "printCategoryCounts", e);
                    }
                });
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printCategoryCounts", e);
        }
    }

    private char getSeparator() {
        if (!this.hasSeparator) {
            this.separator = (char)(this.parameters.getFormat().equals((Object)ValidationErrorFormat.TAB_SEPARATED) ? 9 : 44);
        }
        return this.separator;
    }

    private void printCollectorEntry(Integer errorId, Set<String> recordIds) {
        this.print(this.collectorFile, String.valueOf(errorId) + this.separator);
        boolean isFirst = true;
        for (String recordId : recordIds) {
            this.print(this.collectorFile, (isFirst ? "" : ";") + recordId);
            if (!isFirst) continue;
            isFirst = false;
        }
        this.print(this.collectorFile, "\n");
    }

    private void print(File file, String content) {
        if (this.parameters.useStandardOutput()) {
            System.out.print(content);
        } else {
            this.printToFile(file, content);
        }
    }

    private void updateErrorCollector(String recordId, int errorId) {
        if (!this.validatorDAO.getErrorCollector().containsKey(errorId)) {
            this.validatorDAO.getErrorCollector().put(errorId, new HashSet());
        } else if (this.parameters.doEmptyLargeCollectors() && this.validatorDAO.getErrorCollector().get(errorId).size() >= 1000) {
            this.printCollectorEntry(errorId, this.validatorDAO.getErrorCollector().get(errorId));
            this.validatorDAO.getErrorCollector().put(errorId, new HashSet());
        }
        this.validatorDAO.getErrorCollector().get(errorId).add(recordId);
    }

    public boolean doPrintInProcessRecord() {
        return this.doPrintInProcessRecord;
    }

    public void setDoPrintInProcessRecord(boolean doPrintInProcessRecord) {
        this.doPrintInProcessRecord = doPrintInProcessRecord;
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }

    public List<ValidationError> getAllValidationErrors() {
        return this.allValidationErrors;
    }

    public int getCounter() {
        return this.counter;
    }

    public int getNumberOfprocessedRecords() {
        return this.numberOfprocessedRecords;
    }

    public ValidatorConfiguration getValidityConfiguration() {
        return this.validatorConfiguration;
    }

    private <T> void updateCounters(T key, Set<String> groupIds, Map<T, Integer> counterSingle, Map<String, Map<T, Integer>> counterGrouped) {
        if (this.doGroups()) {
            for (String groupId : groupIds) {
                counterGrouped.computeIfAbsent(groupId, s -> new TreeMap());
                Utils.count(key, counterGrouped.get(groupId));
            }
        } else {
            Utils.count(key, counterSingle);
        }
    }

    private class Counter {
        int id;
        int count;

        public Counter(int count, int id) {
            this.count = count;
            this.id = id;
        }
    }
}

