/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.ThompsonTraillAnalysis;
import de.gwdg.metadataqa.marc.analysis.ThompsonTraillFields;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.ThompsonTraillCompletenessParameters;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.dao.record.Marc21Record;
import de.gwdg.metadataqa.marc.dao.record.PicaRecord;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class ThompsonTraillCompleteness
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(ThompsonTraillCompleteness.class.getCanonicalName());
    private final Options options;
    private final boolean readyToProcess;
    private ThompsonTraillCompletenessParameters parameters;
    private File output = null;

    public ThompsonTraillCompleteness(String[] args) throws ParseException {
        this.parameters = new ThompsonTraillCompletenessParameters(args);
        System.err.println("tt().marcxml: " + this.parameters.isMarcxml());
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
    }

    public static void main(String[] args) throws ParseException {
        ThompsonTraillCompleteness processor = null;
        try {
            processor = new ThompsonTraillCompleteness(args);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        this.printFields();
        this.output = new File(this.parameters.getOutputDir(), this.parameters.getFileName());
        if (this.output.exists() && !this.output.delete()) {
            logger.severe("Deletion of " + this.output.getAbsolutePath() + " was unsuccessful!");
        }
        this.print(Utils.createRow(ThompsonTraillAnalysis.getHeader()));
    }

    @Override
    public void fileOpened(Path path) {
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) {
    }

    @Override
    public void processRecord(BibliographicRecord marcRecord, int recordNumber) {
        if (this.parameters.getRecordIgnorator().isIgnorable(marcRecord)) {
            return;
        }
        List<Integer> scores = ThompsonTraillAnalysis.getScores(marcRecord);
        String id = this.parameters.getTrimId() ? marcRecord.getId().trim() : marcRecord.getId();
        String message = String.format("\"%s\",%s%n", id, StringUtils.join(scores, (String)","));
        this.print(message);
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp qa-catalogue.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    private void print(String message) {
        try {
            FileUtils.writeStringToFile((File)this.output, (String)message, (Charset)Charset.defaultCharset(), (boolean)true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "print", e);
        }
    }

    private void printFields() {
        Path path = Paths.get(this.parameters.getOutputDir(), "tt-completeness-fields.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("name", "transformed", "fields"));
            BibliographicRecord record = this.getParameters().getSchemaType().equals((Object)SchemaType.MARC21) ? new Marc21Record() : new PicaRecord();
            Map<ThompsonTraillFields, List<String>> map = record.getThompsonTraillTagsMap();
            for (ThompsonTraillFields field : ThompsonTraillFields.values()) {
                try {
                    writer.write(Utils.createRow(field.getLabel(), field.getMachine(), Utils.quote(StringUtils.join((Iterable)map.getOrDefault((Object)field, List.of()), (String)","))));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "printFields", e);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printFields", e);
        }
    }
}

