/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.cli.QACli;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.MarcToSolrParameters;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.datastore.MarcSolrClient;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.definition.general.indexer.FieldIndexer;
import de.gwdg.metadataqa.marc.utils.pica.PicaGroupIndexer;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaPath;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.marc4j.marc.Record;

public class MarcToSolr
extends QACli
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(MarcToSolr.class.getCanonicalName());
    private Options options;
    private MarcVersion version;
    private MarcToSolrParameters parameters;
    private MarcSolrClient client;
    private MarcSolrClient validationClient;
    private Path currentFile;
    private boolean readyToProcess;
    private DecimalFormat decimalFormat = new DecimalFormat();
    private FieldIndexer groupIndexer;

    public MarcToSolr(String[] args) throws ParseException {
        this.parameters = new MarcToSolrParameters(args);
        this.initialize();
    }

    public MarcToSolr(MarcToSolrParameters parameters) throws ParseException {
        this.parameters = parameters;
        this.initialize();
    }

    private void initialize() {
        this.options = this.parameters.getOptions();
        this.client = this.parameters.useEmbedded() ? new MarcSolrClient(this.parameters.getMainClient()) : new MarcSolrClient(this.parameters.getSolrUrl());
        this.client.setTrimId(this.parameters.getTrimId());
        if (this.parameters.getValidationUrl() != null) {
            this.validationClient = this.parameters.useEmbedded() ? new MarcSolrClient(this.parameters.getValidationClient()) : new MarcSolrClient(this.parameters.getValidationUrl());
            this.validationClient.setTrimId(this.parameters.getTrimId());
        }
        this.readyToProcess = true;
        this.version = this.parameters.getMarcVersion();
        this.initializeGroups(this.parameters.getGroupBy(), this.parameters.isPica());
        if (this.doGroups()) {
            this.groupIndexer = new PicaGroupIndexer().setPicaPath((PicaPath)this.groupBy);
        }
    }

    public static void main(String[] args) throws ParseException {
        MarcToSolr processor = new MarcToSolr(args);
        processor.options.toString();
        if (StringUtils.isBlank((CharSequence)((MarcToSolrParameters)processor.getParameters()).getSolrUrl())) {
            System.err.println("Please provide a Solr URL and file name!");
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(BibliographicRecord bibliographicRecord, int recordNumber) throws IOException {
        SolrDocument validationValues;
        if (this.parameters.getRecordIgnorator().isIgnorable(bibliographicRecord)) {
            return;
        }
        if (bibliographicRecord.getSchemaType().equals((Object)SchemaType.PICA) && this.doGroups()) {
            for (DataField field : bibliographicRecord.getDatafield(((PicaPath)this.groupBy).getTag())) {
                field.addFieldIndexer(this.groupIndexer);
            }
        }
        Map<String, List<String>> map = bibliographicRecord.getKeyValuePairs(this.parameters.getSolrFieldType(), true, this.parameters.getMarcVersion());
        map.put("record_sni", Arrays.asList(bibliographicRecord.asJson()));
        SolrInputDocument document = this.client.createSolrDoc(bibliographicRecord.getId(), map);
        if (this.validationClient != null && (validationValues = this.validationClient.get(bibliographicRecord.getId())) != null && !validationValues.isEmpty()) {
            for (String field : validationValues.getFieldNames()) {
                document.addField(field, (Object)validationValues.getFieldValues(field));
            }
        }
        this.client.index(document);
        if (recordNumber % 10000 == 0) {
            if (this.parameters.doCommit()) {
                this.client.commit();
            }
            logger.info(String.format("%s/%s (%s)", this.currentFile.getFileName().toString(), this.decimalFormat.format(recordNumber), bibliographicRecord.getId()));
        }
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        this.parameters.setMainClient(null);
        this.parameters.setValidationClient(null);
        this.saveParameters("marctosolr.params.json", this.parameters);
    }

    @Override
    public void fileOpened(Path path) {
        this.currentFile = path;
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        this.client.commit();
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp qa-catalogue.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

