/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.analysis.SerialFields;
import de.gwdg.metadataqa.marc.analysis.SerialScores;
import de.gwdg.metadataqa.marc.dao.Control006;
import de.gwdg.metadataqa.marc.dao.Control008;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import java.util.LinkedList;
import java.util.List;

public class Serial {
    private BibliographicRecord marcRecord;
    private SerialScores scores;
    private static List<String> headers = new LinkedList<String>();

    public Serial(BibliographicRecord marcRecord) {
        this.marcRecord = marcRecord;
        this.scores = new SerialScores();
    }

    public static List<String> getHeader() {
        return headers;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.marcRecord.getDatafield("362") == null ? 0 : this.marcRecord.getDatafield("362").hashCode());
        result = 31 * result + (this.marcRecord.getDatafield("310") == null ? 0 : this.marcRecord.getDatafield("310").hashCode());
        result = 31 * result + (this.marcRecord.getDatafield("022") == null ? 0 : this.marcRecord.getDatafield("022").hashCode());
        result = 31 * result + (this.marcRecord.getDatafield("588") == null ? 0 : this.marcRecord.getDatafield("588").hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Serial other = (Serial)obj;
        if (this.getDatesOfPublication362() == null ? other.getDatesOfPublication362() != null : !this.getDatesOfPublication362().equals(other.getDatesOfPublication362())) {
            return false;
        }
        if (this.getFrequency310() == null ? other.getFrequency310() != null : !this.getFrequency310().equals(other.getFrequency310())) {
            return false;
        }
        if (this.getIssn022() == null ? other.getIssn022() != null : !this.getIssn022().equals(other.getIssn022())) {
            return false;
        }
        return !(this.getSourceOfDescription588() == null ? other.getSourceOfDescription588() != null : !this.getSourceOfDescription588().equals(other.getSourceOfDescription588()));
    }

    public String toString() {
        return "Serial [issn022=" + this.getIssn022() + ", frequency310=" + this.getFrequency310() + ", datesOfPublication362=" + this.getDatesOfPublication362() + ", sourceOfDescription588=" + this.getSourceOfDescription588() + "]";
    }

    private boolean empty(List<DataField> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        return list.get(0).getSubfields().isEmpty();
    }

    private String first(List<DataField> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0).toString();
    }

    public List<DataField> getIssn022() {
        return this.marcRecord.getDatafield("022");
    }

    public List<DataField> getFrequency310() {
        return this.marcRecord.getDatafield("310");
    }

    public List<DataField> getDatesOfPublication362() {
        return this.marcRecord.getDatafield("362");
    }

    public List<DataField> getSourceOfDescription588() {
        return this.marcRecord.getDatafield("588");
    }

    public String getEncodingLevel() {
        return this.marcRecord.getLeader().getEncodingLevel().getValue();
    }

    public List<Integer> determineRecordQualityScore() {
        Control008 control008 = this.marcRecord.getControl008();
        this.detectUnknownDate1(control008);
        this.detectUnknownCountry(control008);
        this.detectUnkownLanguage(control008);
        this.detectAuthenticationCode();
        this.detectEncodingLevel();
        this.detect008();
        this.detectPublisher();
        this.detectPublisherRDA();
        this.detectPublicationFrequency();
        this.detectContentTypeRDA();
        this.detectDateOfPublication();
        this.detectDescriptionSource();
        this.detectLocSubjectHeadings();
        this.detectPPC();
        Serial.detectAutomaticDiscards(control008);
        Serial.detectInactiveTitles(control008);
        this.detectDeletion();
        this.detectDateStartsWith0(control008);
        this.scores.calculateTotal();
        return this.scores.asList();
    }

    private void detectDateStartsWith0(Control008 control008) {
        if (control008 != null && control008.getTag008all07() != null && control008.getTag008all07().getValue().matches("0.+")) {
            this.scores.set(SerialFields.DATE_1_STARTS_WITH_0, -100);
        }
    }

    private void detectDeletion() {
        List<DataField> notes = this.marcRecord.getDatafield("936");
        if (this.empty(notes) || notes.get(0).getSubfield("0") == null || notes.get(0).getSubfield("0").get(0) == null || notes.get(0).getSubfield("0").get(0).getValue() == null || notes.get(0).getSubfield("0").get(0).getValue().contains("DELETION")) {
            // empty if block
        }
    }

    private static void detectInactiveTitles(Control008 control008) {
        if (control008 == null || control008.getTag008all11() == null || control008.getTag008all11().getValue().matches("[0-8].+") || control008.getTag008all11().getValue().matches("u.+")) {
            // empty if block
        }
    }

    private static void detectAutomaticDiscards(Control008 control008) {
        if (control008 == null || control008.getValueByPosition(23) == null || !control008.getValueByPosition(23).equals("o")) {
            // empty if block
        }
    }

    private void detectPPC() {
        if (!this.empty(this.marcRecord.getDatafield("042")) && this.marcRecord.getDatafield("042").get(0) != null && this.marcRecord.getDatafield("042").get(0).getSubfield("a") != null && !this.marcRecord.getDatafield("042").get(0).getSubfield("a").isEmpty() && this.marcRecord.getDatafield("042").get(0).getSubfield("a").get(0).getCode().equals("pcc")) {
            this.scores.set(SerialFields.PCC, 100);
        }
    }

    private void detectLocSubjectHeadings() {
        List<DataField> subjects = this.marcRecord.getSubjects();
        if (subjects.isEmpty()) {
            this.scores.set(SerialFields.HAS_NO_SUBJECT, -5);
        } else {
            this.scores.set(SerialFields.HAS_SUBJECT, subjects.size());
        }
    }

    private void detectDescriptionSource() {
        if (!this.empty(this.marcRecord.getDatafield("588"))) {
            this.scores.set(SerialFields.HAS_SOURCE_OF_DESCRIPTION_588, 1);
        }
    }

    private void detectDateOfPublication() {
        if (!this.empty(this.marcRecord.getDatafield("362"))) {
            this.scores.set(SerialFields.HAS_DATES_OF_PUBLICATION_362, 1);
        }
    }

    private void detectContentTypeRDA() {
        if (!this.empty(this.marcRecord.getDatafield("336"))) {
            this.scores.set(SerialFields.HAS_CONTENT_TYPE_336, 1);
        }
    }

    private void detectPublicationFrequency() {
        if (!this.empty(this.marcRecord.getDatafield("310"))) {
            this.scores.set(SerialFields.HAS_PUBLICATION_FREQUENCY_310, 1);
        }
    }

    private void detectPublisherRDA() {
        if (!this.empty(this.marcRecord.getDatafield("264"))) {
            this.scores.set(SerialFields.HAS_PUBLISHER_264, 1);
        }
    }

    private void detectPublisher() {
        if (!this.empty(this.marcRecord.getDatafield("260"))) {
            this.scores.set(SerialFields.HAS_PUBLISHER_260, 1);
        }
    }

    private void detect008() {
        if (this.marcRecord.getControl006() != null && !this.marcRecord.getControl006().isEmpty()) {
            boolean hasContent = false;
            for (Control006 control006 : this.marcRecord.getControl006()) {
                if (control006.getContent() == null || control006.getContent().equals("")) continue;
                hasContent = true;
                break;
            }
            if (hasContent) {
                this.scores.set(SerialFields.HAS_006, 1);
            }
        }
    }

    private void detectEncodingLevel() {
        String encodingLevel = this.getEncodingLevel();
        if (encodingLevel.equals(" ") || encodingLevel.equals("1") || encodingLevel.equals("I")) {
            this.scores.set(SerialFields.ENCODING_LEVEL_FULL, 5);
        }
        if (encodingLevel.equals("M") || encodingLevel.equals("L") || encodingLevel.equals("K") || encodingLevel.equals("7")) {
            this.scores.set(SerialFields.ENCODING_LEVEL_MINIMAL, 1);
        }
        if (encodingLevel.equals("3")) {
            this.scores.set(SerialFields.ABBREVIATED, -100);
        }
    }

    private void detectAuthenticationCode() {
        List<DataField> authenticationcode = this.marcRecord.getDatafield("042");
        if (!(this.empty(authenticationcode) || authenticationcode.get(0) == null || authenticationcode.get(0).getSubfield("a") == null || authenticationcode.get(0).getSubfield("a").isEmpty() || authenticationcode.get(0).getSubfield("a").get(0).getValue().equals(""))) {
            this.scores.set(SerialFields.AUTH, 7);
        }
    }

    private void detectUnkownLanguage(Control008 control008) {
        if (control008 != null && control008.getTag008all35() != null && control008.getTag008all35().getValue().matches("xxx.+")) {
            this.scores.set(SerialFields.LANGUAGE, -1);
        }
    }

    private void detectUnknownCountry(Control008 control008) {
        if (control008 != null && control008.getTag008all15() != null && control008.getTag008all15().getValue().matches("xx.+")) {
            this.scores.set(SerialFields.COUNTRY_UNKNOWN, -1);
        }
    }

    private void detectUnknownDate1(Control008 control008) {
        if (control008 != null && control008.getTag008all07() != null && control008.getTag008all07().getValue().equals("uuuu")) {
            this.scores.set(SerialFields.DATE_1_UNKNOWN, -3);
        }
    }

    public void print() {
        System.out.print(this.marcRecord.getId() + ", form of item: " + this.marcRecord.getControl008().getValueByPosition(23) + ", issn: " + this.marcRecord.getDatafield("022").get(0).getSubfield("a").get(0).getValue() + ", date1: " + this.marcRecord.getControl008().getTag008all07().getValue() + ", date2: " + this.marcRecord.getControl008().getTag008all11().getValue() + ", encodingLevel: " + this.getEncodingLevel() + ", " + this.scores.get(SerialFields.TOTAL));
    }

    public SerialScores getScores() {
        return this.scores;
    }

    static {
        for (SerialFields field : SerialFields.values()) {
            headers.add(field.getMachine());
        }
    }
}

