/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.utils.pica.organisation.K10Organisation;
import de.gwdg.metadataqa.marc.utils.pica.organisation.K10OrganisationReader;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GroupSelector {
    private OrganizationCodes organizationCodes;
    private Map<String, K10Organisation> orgMap;

    public GroupSelector() {
        this(null);
    }

    public GroupSelector(String groupListFile) {
        if (groupListFile == null) {
            this.organizationCodes = OrganizationCodes.getInstance();
        } else {
            this.orgMap = K10OrganisationReader.fileToCodeList(groupListFile);
        }
    }

    public String getOrgName(String key) {
        K10Organisation x;
        String orgName;
        String string = orgName = key.equals("0") ? "all" : key;
        if (this.organizationCodes != null) {
            EncodedValue x2 = this.organizationCodes.getCode("DE-" + key);
            orgName = x2 == null ? key : x2.getLabel();
        } else if (this.orgMap != null && (x = this.orgMap.get(key)) != null) {
            if (StringUtils.isNotBlank((CharSequence)x.getName())) {
                orgName = x.getName();
            } else if (StringUtils.isNotBlank((CharSequence)x.getCode())) {
                orgName = x.getCode();
            }
        }
        return orgName;
    }
}

