/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.api.util.FileUtils;
import de.gwdg.metadataqa.marc.MarcField;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarcStructureDefinitionReader {
    List<MarcField> fields = new ArrayList<MarcField>();
    Map<String, SubfieldDefinition> qualifiedSubfields = new HashMap<String, SubfieldDefinition>();

    public MarcStructureDefinitionReader(String fileName) throws URISyntaxException, IOException {
        List lines = FileUtils.readLinesFromResource((String)fileName);
        this.lines2fields(lines);
        this.extractQualifiedSubfields();
    }

    private void lines2fields(List<String> lines) {
        MarcField field = null;
        for (String line : lines) {
            if (line.equals("")) {
                field = null;
                continue;
            }
            String[] parts = line.split("\\s+", 3);
            if (field == null) {
                field = new MarcField(parts[0], parts[1], parts[2]);
                this.fields.add(field);
                continue;
            }
            field.addSubfield(parts[0], parts[1], parts[2]);
        }
    }

    public List<MarcField> getFields() {
        return this.fields;
    }

    public Map<String, SubfieldDefinition> getQualifiedSubfields() {
        return this.qualifiedSubfields;
    }

    private void extractQualifiedSubfields() {
        for (MarcField field : this.getFields()) {
            String code = field.getCode();
            this.qualifiedSubfields.put(code + "$ind1", field.getIndicator1());
            this.qualifiedSubfields.put(code + "$ind2", field.getIndicator2());
            for (SubfieldDefinition subfield : field.getSubfieldList()) {
                this.qualifiedSubfields.put(code + "$" + subfield.getCode(), subfield);
            }
        }
    }
}

