package de.gwdg.metadataqa.marc.definition.general.codelist;

import de.gwdg.metadataqa.marc.Utils;

/**
 * Subject Heading and Term Source Codes
 * http://www.loc.gov/standards/sourcelist/subject.html
 */
public class SubjectHeadingAndTermSourceCodes extends CodeList {

  private void initialize() {
    name = "Subject Heading and Term Source Codes";
    url = "http://www.loc.gov/standards/sourcelist/subject.html";
    codes = Utils.generateCodes(
      "aass", "Asian American Studies Library subject headings in A Guide for establishing Asian American core collections (Berkeley, CA: Asian American Studies Library, University of California, Berkeley)",
      "aat", "Art & architecture thesaurus (Los Angeles, CA: Getty Research Institute, Getty Vocabulary Program)",
      "abne", "Autoridades de la Biblioteca Nacional de España (Madrid: Biblioteca Nacional de España)",
      "aedoml", "Listado de encabezamientos de materia de música (Madrid: Asociación Española de Documentación Musical)",
      "afo", "AFO - Viikin kampuskirjaston ontologia (Helsinki: Kansalliskirjasto)",
      "afset", "American Folklore Society Ethnographic Thesaurus",
      "agrifors", "AGRIFOREST-sanasto (Helsinki: Helsingin Yliopisto)",
      "agrovoc", "AGROVOC multilingual agricultural thesaurus (Rome: APIMONDIA)",
      "agrovocf", "AGROVOC thésaurus agricole multilingue (Rome: APIMONDIA)",
      "agrovocs", "AGROVOC tesauro agrícola multilingée (Roma: APIMONDIA)",
      "aiatsisl", "AIATSIS language thesaurus (Canberra: Australian Institute of Aboriginal and Torres Strait Islander Studies)",
      "aiatsisp", "AIATSIS place thesaurus (Canberra: Australian Institute of Aboriginal and Torres Strait Islander Studies)",
      "aiatsiss", "AIATSIS subject Thesaurus (Canberra: Australian Institute of Aboriginal and Torres Strait Islander Studies)",
      "aktp", "Alphavētikos Katalogos Thematikōn Perigrapheōn (Naupaktos: Papacharalampeios Dēmosia Kentrikē Vivliothēkē Naupaktou)",
      "albt", "Arbetslivsbibliotekets tesaurus (Stockholm: Arbetslivsbiblioteket)",
      "allars", "Allärs: allmän tesaurus pä svenska (Helsingfors: BTJ Kirjastopalvelu)",
      "apaist", "APAIS thesaurus: a list of subject terms used in the Australian Public Affairs Information Service (Canberra: National Library of Australia)",
      "armac", "Lista ARMARC de encabezamientos de materia para bibliotecas mayores",
      "asft", "Aquatic sciences and fisheries thesaurus (Rome: Cambridge Scientific Abstracts)",
      "ashlnl", "Arabic Subject Headings of the Lebanese National Library (ASH) = Ru'ûs al-Mawdû'ât al-'Arabîyah lil-Maktabah al-Waṭanīyah al-Lubnānīyah (Lebanese National Library)",
      "asrcrfcd", "Australian Standard Research Classification: Research Fields, Courses and Disciplines (RFCD) classification (Canberra: Australian Bureau of Statistics)",
      "asrcseo", "Australian Standard Research Classification: Socio-Economic Objective (SEO) classification (Canberra: Australian Bureau of Statistics)",
      "asrctoa", "Australian Standard Research Classification: Type of Activity (TOA) classification (Canberra: Australian Bureau of Statistics)",
      "asth", "Astronomy thesaurus (Epping, N.S.W.: Anglo-Australian Observatory for the International Astronomical Union)",
      "ated", "Australian Thesaurus of Education Descriptors (ATED) (Melbourne, Vic.: Australian Council for Educational Research)",
      "atg", "Agricultural thesaurus and glossary (Beltsville, MD: National Agricultural Library)",
      "atla", "Religion indexes: thesaurus (Evanston, IL: American Theological Library Association)",
      "aucsh", "Qâ'imat ru'ûs mawdû'ât al-fahras al-'Arabîyah al-mowahad = Arabic Union Catalog Subject Headings",
      "bare", "BIBSYS authority register (BARE)",
      "barn", "Svenska ämnesord för barn (Stockholm: Svensk biblioteksförening)",
      "bella", "Bella: specialtesaurus för skönlitteratur (Helsingfors: BTJ Kirjastopalvelu)",
      "bet", "British education thesaurus (Leeds: Leeds University Press)",
      "bhammf", "BHA, Bibliographie d'histoire de l'art, mots-matière/français (Paris: Institut national d'information scientifique et technique)",
      "bhashe", "BHA, Bibliography of the history of art, subject headings/English (Santa Monica, CA: J. Paul Getty Trust ; Paris: Centre national de recherche scientifique)",
      "bhb", "Bibliography of the Hebrew Book (National Library of Israel)",
      "bib1814", "1814-bibliografi: emneord for 1814-bibliografi (Oslo: National Library of Norway)",
      "bibalex", "Bibliotheca Alexandrina name and subject authority file (Alexandria, Egypt: Bibliotheca Alexandrina)",
      "biccbmc", "BIC Children's Books Marketing Classifications (London: Book Industry Communication)",
      "bicssc", "BIC standard subject categories (London: Book Industry Communication)",
      "bidex", "Bilindex: a bilingual Spanish-English subject heading list (Oakland: California Spanish Language Data Base)",
      "bisacmt", "BISAC Merchandising Themes",
      "bisacrt", "BISAC Regional Themes",
      "bisacsh", "BISAC Subject Headings",
      "bjornson", "Bjornson: emneord for Bjornsonbibliografien (Oslo: National Library of Norway)",
      "blcpss", "COMPASS subject authority system",
      "blmlsh", "British Library - Map library subject headings (London: British Library)",
      "blnpn", "British Library newspaper place names (London: British Library)",
      "bokbas", "Bokbasen",
      "bt", "Bioethics thesaurus (Washington, DC: Kennedy Institute of Ethics, Georgetown Univ.)",
      "btr", "Brinkman onderwerp thesaurus",
      "cabt", "CAB thesaurus (Slough [England]: Commonwealth Agricultural Bureaux)",
      "cash", "Canadian subject headings (Ottawa, ON: Library and Archives Canada)",
      "cbk", "Centraal Bestand Kinderboeken",
      "cck", "Centrale Catalogus Kaarten",
      "ccsa", "Catalogue collectif suisse des affiches (Berne: Bibliothèque nationale suisse)",
      "cct", "Zhong guo fen lei zhu ti ci biao (di er ban) = Chinese Classified Thesaurus (Beijing: Guo jia tu shu guan 'Zhongguo tu shu guan fen lei fa' bian wei hui)",
      "ccte", "Carto-Canadiana thesaurus - English (Ottawa, ON: Library and Archives Canada)",
      "cctf", "Carto-Canadiana thésaurus - Français (Ottawa, ON: Bibliothèque et Archives Canada)",
      "cdcng", "Catalogage des documents cartographiques: forme et structure des vedettes noms géographiques - NF Z 44-081 (Paris-La Défense: AFNOR)",
      "ceeus", "Counties and equivalent entities of the United States its possessions, and associated areas (Gaithersburg, MD: National Institute of Standards and Technology)",
      "chirosh", "Chiropractic Subject Headings",
      "cht", "Chicano thesaurus for indexing Chicano materials in Chicano periodical index (Berkeley: Chicano Studies Library Publications Unit, University of California, Berkeley)",
      "ciesiniv", "CIESIN indexing vocabulary (University Center, MI: Consortium for International Earth Science Information Network)",
      "cilla", "Cilla: specialtesaurus för musik (Helsingfors: BTJ Kirjastopalvelu)",
      "collett", "Collett-bibliografi: litteratur av og om Camilla Collett (Oslo: National Library of Norway)",
      "conorsi", "CONOR.SI (name authority file) (Maribor, Slovenia: Institut informacijskih znanosti (IZUM))",
      "csahssa", "'Controlled vocabulary' in Health and safety science abstracts (Bethesda, MD: Cambridge Scientific Abstracts)",
      "csalsct", "CSA life sciences collection thesaurus (Bethesda, MD: Cambridge Scientific Abstracts)",
      "csapa", "'Controlled vocabulary' in Pollution abstracts (Bethesda, MD: Cambridge Scientific Abstracts)",
      "csh", "Kapsner, Oliver Leonard. Catholic subject headings (Haverford, PA: Catholic Lib. Assoc.)",
      "csht", "Chinese subject headings (Taipei: National Central Library)",
      "cstud", "Classificatieschema's Bibliotheek TU Delft (Delft: Technische Universiteit Delft, Bibliotheek)",
      "czenas", "Soubor vĕcných autorit Národní knihovny ČR = CZENAS thesaurus: a list of subject terms used in the National Library of the Czech Republic (Praha: Národní knihovna Čseké republiky)",
      "czmesh", "Czech MeSH",
      "dbn", "Deskryptory Biblioteki Narodowej = National Library of Poland Descriptors (Warszawa: Biblioteka Narodowa)",
      "dcs", "Descritores em Ciências da Saúde = Descriptores en Ciencias de la Salud = Health Sciences Descriptors (São Paulo: BIREME)",
      "ddcri", "Dewey Decimal Classification Relative Index (Dublin, Ohio: OCLC Online Computer Center)",
      "ddcrit", "DDC retrieval and indexing terminology; posting terms with hierarchy and KWOC (Alexandria, VA: Defense Documentation Center, Defense Logistics Agency)",
      "ddcut", "Dewey Decimal Classification user terms (Dublin, Ohio: OCLC Online Computer Center)",
      "dissao", "'Dissertation abstracts online' in Search tools: the guide to UNI/Data Courier Online (Louisville, KY: UNI/Data Courier Online)",
      "dit", "Defense intelligence thesaurus (Washington, DC: Defense Intelligence Agency)",
      "dltlt", "Cuddon, J. A. A dictionary of literary terms and literary theory (Oxford ; Malden, Mass.: Blackwell)",
      "dltt", "Quinn, E. A dictionary of literary and thematic terms (New York, NY: Facts on File, Inc.)",
      "drama", "Drama: specialtesaurus för teater och dans (Helsingfors: BTJ Kirjastopalvelu)",
      "dtict", "Defense Technical Information Center thesaurus (Fort Belvoir, VA: DTIC)",
      "ebfem", "Encabezamientos bilingües de la Fundación Educativa Ana G. Mendez (Puerto Rico: Fundación Educativa Ana G. Mendez)",
      "eclas", "ECLAS thesaurus (Luxembourg: European Communities, Office for Official Publications)",
      "eet", "European education thesaurus",
      "eflch", "E4Libraries Category Headings",
      "eks", "Eduskunnan kirjaston asiasanasto (Helsinki: Eduskunnan kirasto)",
      "embiaecid", "Encabezamientos de materia de la Biblioteca Islámica de la Biblioteca AECID (Madrid: AECID)",
      "embne", "Encabezamientos de Materia de la Biblioteca Nacional de España (Madrid: Biblioteca Nacional de España)",
      "emnmus", "Emneord for musikkdokument i EDB-kataloger (Norwegian Directorate for Public and School Libraries)",
      "ept", "Evropski pedagoški tezaver = European education thesaurus (EET) : slovenska razlčica - izdelana po angleški različci (Ljubljana: Zavod Republike Slovenije za solstvo)",
      "erfemn", "Erfaringskompetanses emneord (Nasjonalt senter for erfaringskompetanse innen psykisk helse)",
      "ericd", "Thesaurus of ERIC descriptors (Washington: Educational Resources Information Center, National Institute of Education, U.S. Dept. of Education)",
      "est", "International energy: subject thesaurus ([Paris]: International Energy Agency, Energy Technology Data Exchange)",
      "eum", "Eesti uldine märksonastik",
      "eurovocen", "Eurovoc thesaurus (English)",
      "eurovocfr", "Eurovoc thesaurus (French)",
      "eurovocsl", "Eurovoc thesaurus (Slovenian)",
      "fast", "Faceted application of subject terminology (Dublin, Ohio: OCLC)",
      "fes", "Thesaurus der Bibliothek der FES / FES (Friedrich-Ebert-Stiftung)",
      "finmesh", "FinMeSH",
      "fire", "FireTalk, IFSI thesaurus (Champaign, IL: Illinois Fire Service Institute)",
      "fmesh", "Liste systématique et liste permutée des descripteurs français MeSH (Le Kremlin-Bicêtre, France: Service information médicale automatisée de l'INSERM)",
      "fnhl", "First Nations House of Learning Subject Headings (Vancouver, BC: Xwi7xwa Library, University of British Columbia)",
      "francis", "Base de donneés FRANCIS: plan de classement = FRANCIS database classification scheme (Vandoeuvre: Centre national de la recherche scientifique)",
      "fssh", "FamilySearch Subject Headings (FamilySearch)",
      "galestne", "Gale Group subject thesaurus and named entity vocabulary (Farmington Hills, MI: Gale Group)",
      "gccst", "Government of Canada core subject thesaurus (Gatineau [Quebec]: Library and Archives Canada)",
      "gcipmedia", "GAMECIP - Computer Game Media Formats (GAMECIP (Game Metadata and Citation Project))",
      "gcipplatform", "GAMECIP - Computer Game Platforms (GAMECIP (Game Metadata and Citation Project))",
      "gem", "GEM controlled vocabularies (Syracuse, NY: ERIC Clearinghouse on Information & Technology, Gateway to Educational Materials)",
      "gemet", "GEMET Thesaurus (European Environment Agency (EEA))",
      "geonet", "NGA GEOnet Names Server (GNS) (National Geospatial-Intelligence Agency)",
      "georeft", "GeoRef thesaurus (Alexandria, VA: American Geological Institute)",
      "gnd", "Gemeinsame Normdatei (Leipzig, Frankfurt: Deutsche Nationalbibliothek)",
      "gnis", "Geographic Names Information System (GNIS) (United States Geological Survey, Board on Geographic Names)",
      "gst", "Gay studies thesaurus: a controlled vocabulary for indexing and accessing materials of relevance to gay culture, history, politics and psychology (Princeton, NJ: Michel)",
      "gtt", "GOO-trefwoorden thesaurus (Den Haag: Koninklijke Bibliotheek)",
      "hamsun", "Hamsun: emneord for Hamsunbibliografien (Oslo: National Library of Norway)",
      "hapi", "HAPI thesaurus and name authority, 1970-2000 (Los Angeles, CA: UCLC Latin America Center Pubs.)",
      "helecon", "Asiasanasto HELECON-tietikantoihin (Helsinki: Helsingin Kauppakorkeakoulu)",
      "henn", "Hennepin County Library cumulative authority list (Edina, MN: Hennepin Co. Library)",
      "hkcan", "Hong Kong Chinese Authority File (Name) - HKCAN (Honk Kong: JULAC)",
      "hlasstg", "HLAS subject term glossary (Washington, DC: Library of Congress, Hispanic Division, Handbook of Latin American Studies section)",
      "hoidokki", "Hoitotieteellinen asiasanasto (Helsinki: Sairaanhoitajien koulutussätiö)",
      "hrvmesh", "Croatian MeSH / Hrvatski MeSH (Zagreb: Medicinski fakultet Sveucilita u Zagrebu - Sredinja medicinska knjinica)",
      "huc", "U.S. Geological Survey water-supply paper 2294: hydrologic basins unit codes (Reston, VA: U.S. Geological Survey)",
      "humord", "HUMORD (Norway: Universitetsbibliotekene i Oslo, Bergen og Tromsø)",
      "ibsen", "Ibsen: emneord for Den internasjonale Ibsen-bibliografien (Oslo: National Library of Norway)",
      "ica", "Index of Christian art (Princeton, NJ: Princeton University)",
      "icpsr", "ICPSR controlled vocabulary system (Ann Arbor, MI: Inter-university Consortium for Political and Social Research)",
      "idas", "ID-Archivschlüssel [Informationsdienst zur Verbreitung unterbliebener Nachrichten] (Amsterdam: Internationales Institut für Sozialgeschichte)",
      "idsbb", "Thesaurus IDS Basel Bern (Basel: Universitätsbibliothek; Bern: Universitätsbibliothek)",
      "idszbz", "Thesaurus IDS Nebis Zentralbibliothek Zürich (Zürich: Zentralbibliothek)",
      "idszbzes", "Thesaurus IDS Nebis Bibliothek Englisches Seminar der Universität Zürich (Zürich: Universität Zürich)",
      "idszbzna", "Thesaurus IDS Nebis Zentralbibliothek Zürich, Nordamerika-Bibliothek (Zürich: Zentralbibliothek)",
      "idszbzzg", "Thesaurus IDS Nebis Zentralbibliothek Zürich, Graphische Sammlung (Zürich: Zentralbibliothek)",
      "idszbzzh", "Thesaurus IDS Nebis Zentralbibliothek Zürich, Handschriftenabteilung (Zürich: Zentralbibliothek)",
      "idszbzzk", "Thesaurus IDS Nebis Zentralbibliothek Zürich, Kartensammlung (Zürich: Zentralbibliothek)",
      "iescs", "International energy subject categories and scope (Paris: International Energy Agency)",
      "iest", "International energy: subject thesaurus (Paris, France: International Energy Agency, Energy Technology Data Exchange)",
      "ilpt", "Index to legal periodicals: thesaurus (New York, NY: H.W. Wilson)",
      "inist", "INIS: thesaurus (Vienna: International Atomic Energy Agency)",
      "inspect", "INSPEC thesaurus (London: Institution of Electrical Engineers)",
      "ipat", "IPA thesaurus and frequency list (Bethesda, MD: American Society of Hospital Pharmacists)",
      "ipsp", "Defense intelligence production schedule. (Washington, DC: Defense Intelligence Agency)",
      "isis", "'Classification scheme' in Isis (Chicago, IL: University of Chicago Press)",
      "itglit", "International thesaurus of gay and lesbian index terms (Chicago?: Thesaurus Committee, Gay and Lesbian Task Force, American Library Association)",
      "itrt", "International Thesaurus of Refugee Terminology (New York & Geneva: United Nations High Commissioner for Refugees)",
      "jhpb", "Język haseł przedmiotowych Biblioteki Narodowej = National Library of Poland Subject Headings (Warszawa: Biblioteka Narodowa)",
      "jhpk", "Język haseł przedmiotowych KABA = KABA Subject Headings (Warszawa: Stowarzyszenie Bibliotekarzy Polskich, Centrum Formatów i Kartotek Haseł Wzorcowych Biblioteki Uniwersyteckiej w Warszawie)",
      "jlabsh", "Kihon kenmei hyômokuhyô = [Japan Library Association] Basic subject headings (Tokyo: Nihon Toshokan Kyôkai)",
      "juho", "JUHO - Julkishallinnon ontologia (Helsinki: Kansalliskirjasto)",
      "jupo", "JUPO - Julkisen hallinnon palveluontologia (Helsinki: Kansalliskirjasto)",
      "jurivoc", "JURIVOC",
      "kaa", "Kasvatusalan asiasanasto (Jyväskylä: Kasvatustieteiden tutkimuslaitos)",
      "kaba", "Język haseł przedmiotowych KABA = KABA Subject Headings (Warszawa: Stowarzyszenie Bibliotekarzy Polskich, Centrum Formatów i Kartotek Haseł Wzorcowych Biblioteki Uniwersyteckiej w Warszawie)",
      "kao", "KVINNSAM ämnesordsregister = KVINNSAM subject headings (Göteborg: Göteborgs universitetsbibliotek, Kvinnohistoriska samlingarna)",
      "kassu", "Kassu - Kasvien suomenkieliset nimet (Helsinki: Kansalliskirjasto)",
      "kauno", "KAUNO - Kaunokki-ontologin (Helsinki: Kansalliskirjasto)",
      "kaunokki", "Kaunokki: kaunokirjallisuuden asiasanasto (Helsinki: BTJ Kirjastopalvelu)",
      "kdm", "Khung dê muc hê thông thông tin khoa hoc và ky thuât quôc gia (Hà Nôi: Viên Thông Tin Khoa Hoc Và Ky Thuât Trung Uong)",
      "khib", "Emneord, KHiB Biblioteket (Bergen: Kunst- og designhøgskolen i Bergen, Biblioteket)",
      "kito", "KITO - Kirjallisuudentutkimuksen ontologia (Helsinki: Kansalliskirjasto)",
      "kitu", "Kirjallisuudentutkimuksen asiasanasto (Helsinki: Suomalaisen Kirjallisuuden seura)",
      "kkts", "Katalogos Kathierōmenōn Typōn Syllogikou Katalogou Demosion Vivliothekon (Livadeia: Dēmosia Kentrikē Vivliothēkē Levadeias)",
      "koko", "KOKO-ontologia (Helsinki: Kansalliskirjasto)",
      "kssbar", "Klassifikationssystem for svenska bibliotek. Ämnesordregister. Alfabetisk del (Lund: Bibliotekstjanst)",
      "kta", "Kielitieteen asiasanasto (Helsinki: BTJ Kirjastopalvelu)",
      "kto", "KTO - Kielitieteen ontologia (Helsinki: Kansalliskirjasto)",
      "ktpt", "Kirjasto- ja tietopalvelualan tesaurus (Tampere: Tampereen yliopisto)",
      "ktta", "Käsi - ja taideteollisuuden asiasanasto (Kuopio: Kuopinon kKäsi - ja taideteollisuusakatemia taito- ja tutkimuskeskus Taitemia)",
      "kubikat", "kubikat",
      "kula", "Kulttuurien tutkimuksen asiasanasto (Helsinki: Suomalaisen Kirjallisuuden seura)",
      "kulo", "KULO - Kulttuurien tutkimuksen ontologia (Helsinki: Kansalliskirjasto)",
      "kupu", "He puna kupu/ Maori Wordnet (Wellington: National Library of New Zealand)",
      "lacnaf", "Library and Archives Canada name authority file (Ottawa: ON: Library and Archives Canada)",
      "lapponica", "Lapponica (Helsinki: Kansalliskirjasto)",
      "larpcal", "Lista de assuntos referente ao programa de cadastramento automatizado de livros da USP (São Paulo: Universidade de São Paulo, Sistema Integrado de Bibliotecas)",
      "lcac", "Library of Congress Annotated Children's Cataloging Program subject headings (Washington, DC: LC, Cataloging Distribution Service)",
      "lcdgt", "Library of Congress demographic group term and code List (Washington, DC: LC Policy and Standards Division)",
      "lcsh", "Library of Congress subject headings (Washington, DC: LC, Cataloging Distribution Service)",
      "lcshac", "Children's subject headings in Library of Congress subject headings: supplementary vocabularies (Washington, DC: Library of Congress, Cataloging Distribution Service)",
      "lcstt", "List of Chinese subject terms (Taipei: National Central Library)",
      "lctgm", "Thesaurus for graphic materials: TGM I, Subject terms",
      "lemac", "Llista d'encapçalaments de matèria en català (Barcelona: Biblioteca de Catalunya, Servei de Normalització Bibliogràfica)",
      "lemb", "Lista de encabezamientos de materia para bibliotecas (Santafe de Bogotá: Rojas Eberhard Editores, Ltda)",
      "liito", "LIITO - Liiketoimintaontologia (Helsinki: Kansalliskirjasto)",
      "liv", "Legislative indexing vocabulary (Washington, DC: Library of Congress, Congressional Research Service)",
      "lnmmbr", "Lietuvos nacionalines Martyno Mazvydo bibliotekos rubrikynas (Vilnius: LNMMB)",
      "local", "Locally assigned term",
      "ltcsh", "Land Tenure Center Library list of subject headings (Madison, WI: Land Tenure Center Library, University of Wisconsin-Madison)",
      "lua", "Liikunnan ja urheilun asiasanasto (Jyvässkylä: Likkunnan ja kansanterveyden edustämissätiö)",
      "maaq", "Madâkhil al-asmâ' al-'arabîyah al-qadîmah (Cairo: Maktabah al-Akâdîmîyah)",
      "maotao", "MAO/TAO - Ontologi för museibranschen och Konstindustriella ontologin (Helsinki: Kansalliskirjasto)",
      "mar", "Merenkulun asiasanasto = MariTerm (Maritime technology) (Helsinki: Finnish Maritime Administration)",
      "masa", "Museoalan asiasanasto (Helsinki: Museovirasto)",
      "mech", "Iskanje po zbirki MECH",
      "mero", "MERO - Merenkulkualan ontologia (Helsinki: Kansalliskirjasto)",
      "mesh", "Medical subject headings (Bethesda, MD: National Library of Medicine)",
      "mipfesd", "Macrothesaurus for information processing in the field of economic and social development (Paris: Organisation for Economic Co-operation and Development)",
      "mmm", "'Subject key' in Marxism and the mass media (New York: International General)",
      "mpirdes", "Macrothesaurus para el procesamiento de la información relativa al desarrollo económico y social (Paris: Organización de Cooperación y Desarrollo Económicos)",
      "msc", "Mathematical subject classification (Providence, RI: American Mathematical Society)",
      "msh", "Trimboli, T., and Martyn S. Marianist subject headings [PDF: 138 KB]",
      "mtirdes", "Macrothésaurus pour le traitement de l'information relative au développement économique et social (Paris: Organisation de coopération et développement économiques)",
      "musa", "Musiikin asiasanasto: erikoissanasto (Helsinki: Kirjastopalvelu)",
      "muso", "MUSO - Ontologi för musik (Helsinki: Kansalliskirjasto)",
      "muzeukc", "MuzeMusic UK classical music classification (London: Muze Europe Ltd)",
      "muzeukn", "MuzeMusic UK non-classical music classification (London: Muze Europe Ltd)",
      "muzvukci", "MuzeVideo UK contributor index (London: Muze Europe Ltd)",
      "naf", "NACO authority file",
      "nal", "National Agricultural Library subject headings (Beltsville, MD: National Agricultural Library)",
      "nalnaf", "National Agricultural Library name authority file (Beltsville, Maryland; National Agricultural Library)",
      "nasat", "NASA thesaurus (Washington: NASA, Scientific and Technical Information Office)",
      "nbdbt", "NBD Biblion Trefwoordenthesaurus (Zoetermeer: NBD Biblion)",
      "nbiemnfag", "NBIs emneordsliste for faglitteratur (Oslo: National Library of Norway)",
      "ncjt", "National criminal justice thesaurus (Rockville, MD: U.S. Dept. of Justice, Institute of Justice, National Criminal Justice Reference Service)",
      // -
      // "[former code for this source was “ndllsh”; replaced April, 2011]"
      "ndlsh", "Koktsu Kokkai Toshokan kenmei hyômokuhyô = National Diet Library list of subject headings (Tokyo: Kokuritsu Kokkai Toshokan)",
      "netc", "National Emergency Training Center Thesaurus (NETC) [also available as PDF: 1 MB]",
      "nicem", "NICEM subject headings and classification system (Albuquerque, NM: National Information Center for Educational Media)",
      "nimacsc", "NIMA cartographic subject categories (Bethesda, MD: National Imagery and Mapping Agency)",
      "nlgaf", "Archeio Kathierōmenōn Epikephalidōn (Athēna: Ethnikē vivliothēkē tēs Hellados)",
      "nlgkk", "Katalogos kathierōmenōn onomatōn physikōn prosōpōn (Athēna: Ethnikē vivliothēkē tēs Hellados)",
      "nlgsh", "Katalogos Hellēnikōn thematikōn epikephalidōn (Athēna: Ethnikē vivliothēkē tēs Hellados)",
      "nlmnaf", "National Library of Medicine name authority file (Bethesda, Maryland: National Library of Medicine)",
      "no-ubo-mr", "Menneskerettighets-tesaurus (Norwegian Center for Human Rights, University of Oslo)",
      "noraf", "Norwegian Authority File (Oslo: National Library of Norway)",
      "noram", "Noram: emneord for Norsk-amerikansk samling (Oslo: National Library of Norway)",
      "norbok", "Norbok: emneord i Norsk bokfortegnelse (Norbok) (Oslo: National Library of Norway)",
      "normesh", "Norwegian MeSH (Oslo: Norwegian Institute of Public Health)",
      "noubojur", "Thesaurus of Law (Norway: Universitetsbiblioteket i Oslo)",
      "noubomn", "University of Oslo Library Thesaurus of Science (Realfagstermer) (Norway: Universitetsbiblioteket i Oslo)",
      "nsbncf", "Nuovo Soggettario (Firenze: Biblioteca Nazionale Centrale di Firenze)",
      "nskps", "Priručnik za izradu predmetnog kataloga u Nacionalnoj i sveučilišnoj knjičnici u Zagrebu (Manual for NSK subject headings) (Zagreb: Nacionalne i sveučilišne knjičnice u Zagrebu)",
      "ntcpsc", "'National Translations Center primary subject classification' in National Translations Center primary subject classification and secondary descriptors (Washington, DC: National Translations Center, Cataloging Distribution Service, Library of Congress)",
      "ntcsd", "'National Translations Center secondary descriptors' in National Translation Center primary subject classification and secondary descriptor (Washington, DC: National Translations Center, Cataloging Distribution Service, Library of Congress)",
      "ntids", "Norske tidsskrifter 1700-1820: emneord (Oslo: National Library of Norway)",
      "ntissc", "NTIS subject categories (Springfield, VA: National Technical Information Service)",
      "nzggn", "New Zealand gazetteer of official geographic names (New Zealand Geographic Board Ngā Pou Taunaha o Aotearoa (NZGB))",
      "nznb", "New Zealand national bibliographic (Wellington: National Library of New Zealand)",
      "odlt", "Baldick, C. The Oxford dictionary of literary terms (Oxford ; New York: Oxford University Press)",
      "ogst", "Oregon GILS Subject Tree (Oregon: Oregon State Library and Oregon Information Resource Management Division (IRMD))",
      "opms", "Opetusministeriön asiasanasto (Helsinki: Opetusministeriön)",
      "ordnok", "Ordnokkelen: tesaurus for kulturminnevern (Directorate for Cultural Heritage)",
      "pascal", "Base de donneés PASCAL: plan de classement = PASCAL database classification scheme (Vandoeuvre: Centre national de la recherche scientifique)",
      "pepp", "The Princeton encyclopedia of poetry and poetics (Princeton: Princeton University Press)",
      "peri", "Perinnetieteiden asiasanasto (Helsinki: Kirjastopalvelu)",
      "pha", "Puolostushallinnon asiasanasto (Helsinki: Kirjastopalvelu)",
      "pkk", "Predmetnik za katoliške knjižnice (Ljubljana: Maribor)",
      "pleiades", "Pleiades: A Gazetteer of Past Places",
      "pmbok", "Guide to the project management body of knowledge (PMBOK Guide) (Newtown Square, PA: Project Management Institute)",
      "pmcsg", "Combined standards glossary (Newtown Square, PA: Project Management Institute)",
      "pmont", "Powerhouse Museum Object Name Thesaurus",
      "pmt", "Project management terminology. Newtown Square, PA: Project Management Institute",
      "poliscit", "Political science thesaurus II (Pittsburgh: University Center for International Studies, University of Pittsburgh)",
      "popinte", "POPIN thesaurus: population multilingual thesaurus (Paris: Population Information Network)",
      "precis", "PRECIS: a manual of concept analysis and subject indexing (London: British Library)",
      "prvt", "Patent- och registreringsverkets tesaurus (Stockholm: Patent- och Registreringsverket)",
      "psychit", "Thesaurus of psychological index terms. (Washington: American Psychological Association)",
      "puho", "PUHO - Puolustushallinnon ontologia (Helsinki: Kansalliskirjasto)",
      "qlsp", "Queens Library Spanish language subject headings (Queens, New York: Queens Library)",
      "qrma", "Qâ'imat ru'ûs al-mawdûât al-'Arabîyah = List of Arabic subject headings (al-Kuwayt: Dhat al-Salasil)",
      "qrmak", "Qâ'imat ru'ûs al-mawdû'ât al-'Arabîyah al-qiyâsîyah al-maktabât wa-marâkaz al-ma'lûmât wa-qawâid al-bayânât (al-Qâhirah: Dâr Shurûq)",
      "qtglit", "A queer thesaurus : an international thesaurus of gay and lesbian index terms (Amsterdam: Homodok)",
      "quiding", "Quiding, Nils Herman. Svenskt allmänt författningsregister för tiden från år 1522 till och med år 1862 (Stockholm: Norstedt)",
      "ram", "RAMEAU: répertoire d'authorité de matières encyclopédique unifié (Paris: Bibliothèque nationale)",
      "rasuqam", "Répertoire d'autorités-sujet de l'UQAM (Montéral: Université du Québec Montréal, Services techniques des bibliothèques)",
      "renib", "Renib [base de datos de autoridad] (Santiago de Chile: Biblioteca Nacional)",
      "reo", "Māori Subject Headings thesaurus -- Ngā Ūpoko Tukutuku",
      "rero", "Indexation matires RERO (Martigny: Réseau des bibliothèques de Suisse occidentale)",
      "rerovoc", "Indexation matiéres RERO autoritès (Martigny: Rèseau des bibliothéques de Suisse occidentale)",
      "rma", "Ru'us al-mawdu'at al-'Arabiyah (al-Riyad: 'Imadat Shu'un al-Maktabah, Jam. al-Riyad)",
      "rpe", "Rubrikator po ekonomike = Rubricator on economics (Moskva: Institut nauchnoi informatsii po obshchestvennym naukam)",
      "rswk", "Regeln für den Schlagwortkatalog (Berlin: Deutsches Bibliotheksinstitut)",
      "rswkaf", "Alternativform zum Hauptschlagwort",
      "rugeo", "Natsional'nyi normativnyi fail geograficheskikh nazvanii Rossiiskoi Federatsii (Moskva: Rossiiska íà gosudarstvennaíà biblioteka)",
      "rurkp", "Predmetnye rubriki Rossiiskoi knizhnoi palaty (Moskva: Rossiiskaíà knizhnaíà palata)",
      "rvm", "Répertoire de vedettes-matière (Québec, Québec: Bibliothèque de l'Université Laval)",
      "rvmgd", "Thésaurus des descripteurs de groupes démographiques de l'Université Laval Québec: Université Laval)",
      "samisk", "Sámi bibliografia (Norga) = Samisk bibliografi (Norge) = Sami bibliography (Norway) (Oslo: National Library of Norway)",
      "sanb", "South African national bibliography authority file",
      "sao", "Svenska ämnesord (Stockholm: Kungliga Biblioteket, LIBRIS-avdelningen)",
      "sbiao", "Svenska barnboksinstitutets ämnesordslista (Stockholm: Svenska barnboksinstitutet)",
      "sbt", "Soggettario Sistema Bibliotecario Ticinese (Cantone Ticino, Svizzera: Sistema Bibliotecario Ticinese)",
      "scbi", "Soggettario per i cataloghi delle biblioteche italiane (Firenze: Biblioteca Nazionale Centrale di Firenze)",
      "scgdst", "Subject categorization guide for defense science and technology (Fort Belvoir, VA: Defense Technical Information Center, Defense Logistics Agency)",
      "scisshl", "SCIS subject headings (Carlton South, Vic.: Curriculum Corp.)",
      "scot", "Schools Online Thesaurus (ScOT) (Melbourne, Vic.: Education Services Australia Ltd.)",
      "sears", "Sears list of subject headings (New York: H.W. Wilson)",
      "sfit", "Svenska filminstitutets tesaurus (Stockholm: Svenska filminstitutet)",
      "sgc", "Splolšni geslovnik COBISS.SI = COBISS.SI General List of subject headings (Slovenian subject headings) (Maribor, Slovenia: Institut informacijskih znanosti (IZUM))",
      "sgce", "Splošni geslovnik COBISS.SI = COBISS.SI General List of subject headings (English subject headings) (Maribor, Slovenia: Institut informacijskih znanosti (IZUM))",
      "shbe", "Subject headings in business and economics (Stockholm: Handelshögskolan i Stockholm)",
      "she", "SHE: subject headings for engineering (New York: Engineering Index, inc.)",
      "shsples", "Subject headings for school and public libraries = Encabezamientos de materia para bibliotecas escolares y públicas (Santa Barbara, Calif.: Libraries Unlimited)",
      "sigle", "SIGLE [System for Information on Grey Literature in Europe] manual, Part 2, Subject category list (Den Haag: European Association for Grey Literature Exploitation)",
      "sipri", "SIPRI library thesaurus (Stockholm: Stockholm International Peace Research Institute)",
      "sk", "'Zhong guo gu ji shan ban shu zong mu' fen lei biao [Si ku] (Beijing: Zhong guo gu ji shan ban shu zong mu bian ji ling dao xiao zu ban gong shi)",
      "skon", "Att indexera skönlitteratur: Ämnesordslista, vuxenlitteratur (Stockholm: Svensk biblioteksförening)",
      "slem", "Sears: lista de encabezamientos de materia (New York: H. W. Wilson)",
      "smda", "Smithsonian National Air and Space Museum Directory of Airplanes (Washington, DC: Smithsonian Air & Space Museum)",
      "snt", "Sexual nomenclature: a thesaurus (Boston: G.K. Hall)",
      "socio", "Sociological Abstracts Thesaurus (Bethesda, Maryland: CSA)",
      "solstad", "Solstad: emneord for Solstadbibliografien (Oslo: National Library of Norway)",
      "sosa", "Sociaalialan asiasanasto (Helsinki: BTJ Kirjastopalvelu)",
      "spines", "Tesauro SPINES: un vocabulario controlado y estructurado para el tratamiento de información sobre ciencia y tecnología para el desarrollo (Madrid: UNESCO, ICYT)",
      "ssg", "Splošni slovenski geslovnik",
      "sthus", "Subject Taxonomy of the History of U.S. Foreign Relations (U. S. Department of State, Office of the Historian)",
      "stw", "Standard-Thesaurus Wirtschaft = STW Thesaurus for Economics (Kiel: ZBW - Deutsche Zentralbibliothek fur Wirtschaftswissenschaften)",
      "swd", "Schlagwortnormdatei (Frankfurt am Main: Die Deutsche Bibliothek)",
      "swemesh", "Svenska MeSH = Swedish MeSH (Stockholm: Karolinska Institutets Bibliotek)",
      "taika", "Taideteollisuuden asiasanasto (Helsinki: Kirjastopalvelu)",
      "tasmas", "Tesaurus de Asuntos Sociales del Ministerio de Asuntos Sociales de España (Madrid: Ministerio de Asuntos Sociales de España)",
      "taxhs", "A taxonomy or human services: a conceptual framework with standardized terminology and definitions for the field (El Monte, CA: Info. and Referral Fed. of LA County)",
      "tbjvp", "Tesauro de la Biblioteca Dr. Jorge Villalobos Padilla, S.J. (Guadalajara: ITESO Universidad Jesuita de Guadalajara)",
      "tekord", "TEK-ord : UBiTs emneordliste for arkitektur, realfag, og teknolog (Norway: Universitetsbiblioteket i Trondheim)",
      "tero", "TERO - Terveyden ja hyvinvoinnin ontologia (Helsinki: Kansalliskirjasto)",
      "tesa", "Tesauro Agrícola (Beltsville, Maryland: National Agricultural Library)",
      "tesbhaecid", "Tesauro de la Biblioteca Hispánica de la Biblioteca AECID (Madrid: AECID)",
      "test", "Thesaurus of engineering and scientific terms (Washington: U.S. Dept. of Defense)",
      "tgn", "Getty thesaurus of geographic names (Los Angeles, CA: Getty Research Institute)",
      "tha", "Barcala de Moyano, Graciela G., Cristina Voena. Tesauro de Historia Argentina (Buenos Aires, Editorial Dunken)",
      "thesoz", "Thesaurus for the Social Sciences (Germany: GESIS - Leibniz Institute for the Social Sciences)",
      "thia", "Th.I.A. - Thesaurus italiano infanzia e adolescenza = Th.I.A. - Italian Thesaurus on Childhood and Adolescence (Italian National Childhood and Adolescence Documentation and Analysis Center)",
      "tho", "Thesauros Hellēnikōn Oron (Athēna: Ethniko Kentro Tekmēriosēs)",
      "thub", "Thesaurus de la Universitat de Barcelona (Barcelona: Universitat de Barcelona, Centre de Recursos per a l'Aprenentatge i la Investigació, Procés Tècnic)",
      "tips", "Tesauro ISOC de psicología (Madrid: Instituto de estudios documentales sobre ciencia y tecnologia)",
      "tisa", "Villagrá Rubio, Angel. Tesauro ISOC de sociología autores (Madrid: Instituto de estudios documentales sobre ciencia y tecnologia)",
      "tlka", "Investigació, Procés Tècnicn kirjaston asiasanasto (Helsinki: Työväenliikkeen kirjasto)",
      "tlsh", "Subject heading authority list (Evanston, Ill.: Northwestern University Library, Transportation Library)",
      "trfarn", "Lokale trefwoorden De Bibliotheek Arnhem",
      "trfbmb", "Lokale trefwoorden Bibliotheek Midden-Brabant",
      "trfgr", "Lokale trefwoorden Biblionet Groningen",
      "trfoba", "Lokale trefwoorden OBA (Openbare Bibliotheek Amsterdam)",
      "trfzb", "Lokale trefwoorden Zeeuwse Bibliotheken",
      "trt", "Transportation resource thesaurus (Silver Spring, MD: CDB Enterprises)",
      "trtsa", "Teatterin ja tanssin asiasanasto (Helsinki: BTJ Kirjastopalvelu)",
      "tsht", "Thesaurus of subject headings for television (Phoenix, AZ: Oryx Press)",
      "tsr", "TSR-ontologia (Helsinki: Kansalliskirjasto)",
      "ttka", "Teologisen tiedekunnan kirjaston asiasanasto (Helsinki: Helsingin yliopisto)",
      "ttll", "Roggau, Zunilda. Tell. Tesauro de lengua y literatura (Santa Fe, Argentina: Nuevo Parhadigma)",
      "tucua", "Thesaurus for use in college and university archives (Chicago, IL: Society of American Archivists)",
      "udc", "Universal decimal classification (London: British Standards Institute)",
      "ukslc", "UK Standard Library Categories (London: BIC)",
      "ulan", "Union list of artist names (Los Angeles: Getty Research Institute)",
      "umitrist", "University of Michigan Transportation Research Institute structured thesaurus (Ann Arbor, MI: Research Information and Publications Center, University of Michigan, Transportation Research Institute)",
      "unbisn", "UNBIS name authority list (New York, NY: Dag Hammarskjld Library, United Nations; [London]: Chadwyck-Healey)",
      "unbist", "UNBIS thesaurus (New York, NY: Dag Hammarskjld Library, United Nations)",
      "unescot", "UNESCO thesaurus = Thésaurus de l'UNESCO = Tesauro de la UNESCO (Paris: UNESCO Publishing)",
      "usaidt", "USAID thesaurus: Keywords used to index documents included in the USAID Development Experience System. (Washington, DC: U.S. Agency for International Development)",
      "valo", "VALO - Fotografiska ontologin (Helsinki: Kansalliskirjasto)",
      "vcaadu", "Vocabulario controlado de arquitectura, arte, diseño y urbanismo (Buenos Aires: Vitruvio Red de Bibliotecas de arquitectura, arte, diseño y urbanismo, Subcomisión de lenguaje)",
      "vffyl", "Vocabulario de la Biblioteca Central de la FFyL (Buenos Aires: Facultad de Filosofa y Letras de la Universidad de Buenos Aires)",
      "vmj", "Vedettes-matière jeunesse (Montréal, QC: Services documentaires multimédia)",
      "waqaf", "Maknas Uloom Al Waqaf (Kuwait: Kuwait Awqaf Public Foundation)",
      "watrest", "Thesaurus of water resources terms: a collection of water resources and related terms for use in indexing technical information (Washington: U.S. Bureau of Reclamation)",
      "wgst", "Washington GILS Subject Tree (Tumwater, WA: Washington State Library)",
      "wot", "A Women's thesaurus (New York: Harper & Row)",
      "wpicsh", "WPIC Library thesaurus of subject headings (Pittsburgh, PA: Western Psychiatric Institute and Clinic Library, University of Pittsburgh, School of Medicine)",
      "ysa", "Yleinen suomalainen asiasanasto (Helsinki: Kirjastopalvelu)",
      "yso", "YSO - Yleinen suomalainen ontologia (Helsinki: Kansalliskirjasto)"
    );
    indexCodes();
  }

  private static SubjectHeadingAndTermSourceCodes uniqueInstance;

  private SubjectHeadingAndTermSourceCodes() {
    initialize();
  }

  public static SubjectHeadingAndTermSourceCodes getInstance() {
    if (uniqueInstance == null)
      uniqueInstance = new SubjectHeadingAndTermSourceCodes();
    return uniqueInstance;
  }
}
