package de.gwdg.metadataqa.marc.definition.general.codelist;

import de.gwdg.metadataqa.marc.Utils;

/**
 * Standard Identifier Source Codes
 * https://www.loc.gov/standards/sourcelist/standard-identifier.html
 */
public class StandardIdentifierSourceCodes extends CodeList {

  private void initialize() {
    name = "Standard Identifier Source Codes";
    url = "https://www.loc.gov/standards/sourcelist/standard-identifier.html";
    codes = Utils.generateCodes(
      "agorha", "AGORHA (Accès Global et Organisé aux Ressources en Histoire de l'Art)",
      "agrovoc", "AGROVOC multilingual agricultural thesaurus (Rome: APIMONDIA)",
      "allmovie", "AllMovie",
      "allmusic", "AllMusic",
      "allocine", "AlloCiné",
      "amnbo", "American National Biography Online",
      "ansi", "American National Standards Institute and National Information Standards Organisation number for an ANSI or ANSI/NISO standard",
      "artsy", "Artsy",
      "artukart", "Art UK Artists",
      "artukaw", "Art UK Artworks",
      "balat", "BALaT (Belgian Art Links and Tools) People & Institutions",
      "bbcth", "BBC Things",
      "bdusc", "Biographical Directory of the United States Congress (United States Congress)",
      "belvku", "Belvedere Künstler",
      "belvwrk", "Belvedere Werke",
      "benezit", "Benezit Dictionary of Artists",
      "bfi", "BFI - British Film Institute",
      "bnfcg", "BnF catalogue général (Paris: Bibliothèque nationale de France)",
      "cantic", "CANTIC (Catàleg d'autoritats de noms i títols de Catalunya) (Biblioteca de Catalunya)",
      "cerl", "CERL Thesaurus",
      "cgndb", "Canadian Geographical Names Database (Natural Resources Canada)",
      "clara", "Clara: Database of Women Artists (National Museum of Women in the Arts)",
      "csfdcz", "Cesko-Slovenská filmová databáze",
      "danacode", "Danacode (Bnei Brak, Israel: D.A.N.A. Systems)",
      "datoses", "datos.bne.es (Biblioteca Nacional de España)",
      "discogs", "Discogs",
      "dkfilm", "Det Danske Filminstitut Filmdatabasen",
      "doi", "Digital Object Identifier",
      "dpb", "Dictionnaire des peintres belges",
      "ean", "International Article Number",
      "eidr", "EIDR: Entertainment Identifier Registry",
      "emlo", "Early Modern Letters Online",
      "fast", "FAST - Faceted Application of Subject Terminology",
      "fidecp", "Fide Chess Profile (World Chess Federation)",
      "filmport", "filmportal.de",
      "findagr", "Find a Grave",
      "freebase", "Freebase",
      "gec", "Gran enciclopèdia catalana",
      "geogndb", "Geographic Names Database",
      "geonames", "GeoNames",
      "gettyart", "J. Paul Getty Museum Artists",
      "gettyobj", "J. Paul Getty Museum Objects",
      "gettytgn", "Getty Thesaurus of Geographic Names Online (J. Paul Getty Trust)",
      "gettyulan", "Union List of Artist Names Online (J. Paul Getty Trust)",
      "gnd", "Gemeinsame Normdatei (Leipzig: Deutsche Nationalbibliotheke)",
      "gnis", "Geographic Names Information System (GNIS) (United States Geological Survey, Board on Geographic Names)",
      "gtaa", "Gemeenschappelijke Thesaurus Audiovisuele Archieven",
      "gtin-14", "Global Trade Identification Number 14 (EAN/UCC-128 or ITF-14)",
      "hdl", "Handle",
      "ibdb", "IBDB - Internet Broadway Database",
      "idref", "IdRef: le référentiel des autorités Sudoc (L'agence bibliographique de l'enseignement supérieur ABES)",
      "imdb", "IMDb - Internet Movie Database",
      "isan", "International Standard Audiovisual Number",
      "isbn", "International Standard Book Number",
      "isbn-a", "International Standard Book Number (the actionable ISBN)",
      "ismn", "International Standard Music Number",
      "isni", "International Standard Name Identifier",
      "iso", "International Organization for Standardization number for an ISO standard",
      "isbnre", "ISBN (International Standard Book Number) registrant element",
      "isfdbau", "ISFDB Author Directory (The Internet Speculative Fiction Database)",
      "isfdbaw", "ISFDB Award Directory (The Internet Speculative Fiction Database)",
      "isfdbma", "ISFDB Magazine Directory (The Internet Speculative Fiction Database)",
      "isfdbpu", "ISFDB Publisher Directory (The Internet Speculative Fiction Database)",
      "isil", "ISIL (International Standard Identifier for Libraries and Related Organizations)",
      "isrc", "International Standard Recording Code",
      "issn", "International Standard Serial Number",
      "issn-l", "Linking International Standard Serial Number",
      "issue-number", "Sound recording issue number",
      "istc", "International Standard Text Code",
      "iswc", "International Standard Musical Work Code",
      "itar", "ITAR (Importtjeneste og autoritetsregistre)",
      "kda", "Kunstindeks Danmark Artist",
      "kdw", "Kunstindeks Danmark Work",
      "kinopo", "КиноПоиск = KinoPoisk",
      "lccn", "Library of Congress Control Number",
      "lcmd", "Library of Congress Manuscript Division (Washington, DC: Library of Congress)",
      "lei", "Legal Entity Identifier",
      "libaus", "Libraries Australia (National Library of Australia)",
      "local", "Locally defined identifier",
      "matrix-number", "Sound recording matrix number",
      "mocofo", "Musée d'Orsay Catalogue des oeuvres Fiche Oeuvre",
      "moma", "Museum of Modern Art (New York: Museum of Modern Art)",
      "morana", "Musée d'Orsay Répertoire des artistes Notice Artiste",
      "moviemetf", "MovieMeter Films",
      "moviemetr", "MovieMeter Regisseurs",
      "munzing", "Munzinger (Munzinger Archiv)",
      "music-plate", "Publisher's music plate number",
      "music-publisher", "Publisher-assigned music number",
      "musicb", "MusicBrainz",
      "natgazfid", "U.S. National Gazetteer Feature Name Identifier",
      "nga", "National Gallery of Art (Washington DC: National Gallery of Art)",
      "ngva", "National Gallery of Victoria Artist",
      "ngvw", "National Gallery of Victoria Work",
      "nipo", "Número de Identificación de las Publicaciones Oficiales",
      "npg", "National Portrait Gallery (London: National Portrait Gallery)",
      "nndb", "NNDB (Notable Names Database)",
      "odnb", "Oxford Dictionary of National Biography (Oxford University Press)",
      "onix", "ONIX (Online Information Exchange)",
      "opensm", "OpenStreetMap",
      "orcid", "Open Researcher and Contributor Identifier",
      "oxforddnb", "Oxford Biography Index",
      "picnypl", "PIC - Photographers' Identities Catalog (New York Public Library)",
      "porthu", "PORT.hu",
      "prabook", "Prabook",
      "rbmsbt", "RBMS Controlled Vocabularies: Binding Terms (Rare Books and Manuscripts Section, Association of College & Research Libraries)",
      "rbmsgt", "RBMS Controlled Vocabularies: Genre Terms (Rare Books and Manuscripts Section, Association of College & Research Libraries)",
      "rbmspe", "RBMS Controlled Vocabularies: Provenance Evidence (Rare Books and Manuscripts Section, Association of College & Research Libraries)",
      "rbmsppe", "RBMS Controlled Vocabularies: Printing and Publishing Terms (Rare Books and Manuscripts Section, Association of College & Research Libraries)",
      "rbmspt", "RBMS Controlled Vocabularies: Paper Terms (Rare Books and Manuscripts Section, Association of College & Research Libraries)",
      "rbmsrd", "RBMS Controlled Vocabularies: Relationship Designators (Rare Books and Manuscripts Section, Association of College & Research Libraries)",
      "rbmste", "RBMS Controlled Vocabularies: Type Evidence (Rare Books and Manuscripts Section, Association of College & Research Libraries)",
      "rid", "ResearcherID (Thomson Reuters)",
      "rkda", "RKDartists& (Den Haag: Rijksbureau voor Kunsthistorische Documentatie)",
      "saam", "Smithsonian American Art Museum (Washington DC: Smithsonian Institution)",
      "scholaru", "Scholar Universe",
      "scope", "Scope",
      "scopus", "Scopus Author Identifier",
      "sici", "Serial Item and Contribution Identifier",
      "snac", "Social Networks and Archival Context",
      "spotify", "Spotify",
      "sprfbsb", "Sports Reference: Baseball",
      "sprfbsk", "Sports Reference: Basketball",
      "sprfcbb", "Sports Reference: College Basketball",
      "sprfcfb", "Sports Reference: College Football",
      "sprfhoc", "Sports Reference: Hockey",
      "sprfoly", "Sports Reference: Olympic Sports",
      "sprfpfb", "Sports Reference: Pro Football",
      "stock-number", "Publisher, distributor, or vendor stock number",
      "strn", "Standard Technical Report Number",
      "svfilm", "Svensk Filmdatabas",
      "tatearid", "Tate Artist Identifier",
      "theatr", "Theatricalia",
      "trove", "Trove (National Library of Australia)",
      "upc", "Universal Product Code",
      "uri", "Uniform Resource Identifier",
      "urn", "Uniform Resource Name",
      "vd16", "Verzeichnis der Drucke des 16. Jahrhunderts",
      "vd17", "Verzeichnis der Drucke des 17. Jahrhunderts",
      "vd18", "Verzeichnis der Drucke des 18. Jahrhunderts",
      "viaf", "Virtual International Authority File number",
      "videorecording-identifier", "Publisher-assigned videorecording number",
      "wikidata", "Wikidata (Wikimedia Foundation)",
      "wndla", "Web NDL Authorities (Tokyo: National Diet Library (NDL))"
    );
    indexCodes();
  }

  private static StandardIdentifierSourceCodes uniqueInstance;

  private StandardIdentifierSourceCodes() {
    initialize();
  }

  public static StandardIdentifierSourceCodes getInstance() {
    if (uniqueInstance == null)
      uniqueInstance = new StandardIdentifierSourceCodes();
    return uniqueInstance;
  }
}
