/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.marc4j.MarcStreamWriter;
import org.marc4j.MarcXmlReader;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.UnicodeToAnsel;
import org.marc4j.converter.impl.UnicodeToIso5426;
import org.marc4j.converter.impl.UnicodeToIso6937;
import org.marc4j.marc.Record;

public class XmlMarcDriver {
    private XmlMarcDriver() {
    }

    public static void main(String[] args2) {
        long start = System.currentTimeMillis();
        String input = null;
        String output = null;
        String stylesheet = null;
        String convert = null;
        String encoding = null;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-xsl")) {
                if (i == args2.length - 1) {
                    XmlMarcDriver.usage();
                }
                stylesheet = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-out")) {
                if (i == args2.length - 1) {
                    XmlMarcDriver.usage();
                }
                output = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-convert")) {
                if (i == args2.length - 1) {
                    XmlMarcDriver.usage();
                }
                convert = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-encoding")) {
                if (i == args2.length - 1) {
                    XmlMarcDriver.usage();
                }
                encoding = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-usage")) {
                XmlMarcDriver.usage();
                continue;
            }
            if (args2[i].equals("-help")) {
                XmlMarcDriver.usage();
                continue;
            }
            input = args2[i].trim();
            if (i == args2.length - 1) continue;
            XmlMarcDriver.usage();
        }
        if (input == null) {
            XmlMarcDriver.usage();
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(input));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        MarcXmlReader reader = null;
        if (stylesheet == null) {
            reader = new MarcXmlReader(in);
        } else {
            StreamSource source2 = new StreamSource(stylesheet);
            reader = new MarcXmlReader((InputStream)in, (Source)source2);
        }
        OutputStream out = null;
        if (output != null) {
            try {
                out = new FileOutputStream(output);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            out = System.out;
        }
        MarcStreamWriter writer = null;
        writer = encoding != null ? new MarcStreamWriter(out, encoding) : new MarcStreamWriter(out);
        if (convert != null) {
            CharConverter charconv = null;
            if ("MARC8".equals(convert)) {
                charconv = new UnicodeToAnsel();
            } else if ("ISO5426".equals(convert)) {
                charconv = new UnicodeToIso5426();
            } else if ("ISO6937".equals(convert)) {
                charconv = new UnicodeToIso6937();
            } else {
                System.err.println("Unknown character set");
                System.exit(1);
            }
            writer.setConverter(charconv);
        }
        while (reader.hasNext()) {
            Record record = reader.next();
            if ("MARC8".equals(convert)) {
                record.getLeader().setCharCodingScheme(' ');
            }
            writer.write(record);
        }
        writer.close();
        System.err.println("Total time: " + (System.currentTimeMillis() - start) + " miliseconds");
    }

    private static void usage() {
        System.err.println("MARC4J, Copyright (C) 2002-2006 Bas Peters");
        System.err.println("Usage: org.marc4j.util.XmlMarcDriver [-options] <file.mrc>");
        System.err.println("       -convert <encoding> = Converts UTF-8 to <encoding>");
        System.err.println("       Valid encodings are: MARC8, ISO5426, ISO6937");
        System.err.println("       -encoding <encoding> = Output using specified Java character encoding");
        System.err.println("       -xsl <file> = Pre-process MARCXML using XSLT stylesheet <file>");
        System.err.println("       -out <file> = Output using <file>");
        System.err.println("       -usage or -help = this message");
        System.err.println("The program outputs MARC records in ISO 2709 format");
        System.err.println("See http://marc4j.tigris.org for more information.");
        System.exit(1);
    }
}

