/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.marc4j.MarcReader;
import org.marc4j.MarcReaderConfig;
import org.marc4j.MarcReaderFactory;
import org.marc4j.MarcWriter;
import org.marc4j.MarcWriterFactory;
import org.marc4j.marc.Record;

public class RecordIODriver {
    String input;
    String output;
    String convert;
    boolean normalize = false;
    boolean pretty = true;
    boolean oversize = false;
    int splitAt = 0;
    boolean writeErrorRecs = true;
    boolean writeNoErrorRecs = true;
    List<String> otherArgs = new ArrayList<String>();
    MarcReaderConfig readerConfig = new MarcReaderConfig();

    public String getInputName() {
        return this.input;
    }

    public String getOutputName() {
        return this.output;
    }

    public String getConvertValue() {
        return this.convert;
    }

    public boolean shouldNormalize() {
        return this.normalize;
    }

    public boolean shouldPrettify() {
        return this.pretty;
    }

    public boolean shouldWriteErrorRecs() {
        return this.writeErrorRecs;
    }

    public boolean shouldWriteNoErrorRecs() {
        return this.writeNoErrorRecs;
    }

    public MarcReaderConfig getReaderConfig() {
        return this.readerConfig;
    }

    public List<String> getOtherArgs() {
        return this.otherArgs;
    }

    public static void main(String[] args2) {
        RecordIODriver driverInfo = new RecordIODriver();
        RecordIODriver.processArgumentsToConfig(driverInfo, args2);
        InputStream in = null;
        try {
            in = driverInfo.input == null || driverInfo.input.equals("-") ? System.in : new FileInputStream(driverInfo.input);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        OutputStream out = null;
        if (driverInfo.output != null) {
            try {
                out = new FileOutputStream(driverInfo.output);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            out = System.out;
        }
        MarcWriter writer = null;
        try {
            writer = RecordIODriver.makeWriterFromConvertParm(driverInfo, out);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Error: " + iae.getMessage());
            System.exit(1);
        }
        MarcReader reader = null;
        try {
            reader = MarcReaderFactory.makeReader(driverInfo.readerConfig, in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String previousControlNumber = "n/a";
        while (reader.hasNext()) {
            String controlNumber;
            block13: {
                controlNumber = "n/a";
                String location = "after";
                try {
                    location = "after";
                    Record record = reader.next();
                    location = "in";
                    controlNumber = record.getControlNumber();
                    if (!(driverInfo.writeErrorRecs && driverInfo.writeNoErrorRecs || driverInfo.writeErrorRecs && record.hasErrors()) && (!driverInfo.writeNoErrorRecs || record.hasErrors())) break block13;
                    writer.write(record);
                }
                catch (RuntimeException re) {
                    System.err.printf("Exception %s record: %s -- %s\n", location, location.equals("after") ? previousControlNumber : controlNumber, re.getMessage());
                    re.printStackTrace(System.err);
                    break;
                }
            }
            previousControlNumber = controlNumber;
        }
        writer.close();
    }

    protected static RecordIODriver processArgumentsToConfig(RecordIODriver driverInfo, String[] args2) {
        File editFile;
        String editProperties = null;
        String encoding = "MARC8";
        String deleteSubfieldsSpec = null;
        String filterIfPresent = null;
        String filterIfMissing = null;
        String combineConsecutiveRecordsFieldParm = null;
        boolean toUtf8 = true;
        boolean strict = false;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-out") || args2[i].equals("-o")) {
                if (i == args2.length - 1) {
                    RecordIODriver.usage("Missing argument for option " + args2[i] + " should be file to write output", 1);
                }
                driverInfo.output = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-edit")) {
                if (i == args2.length - 1) {
                    RecordIODriver.usage("Missing argument for option " + args2[i] + " should be properties file describing edits to perform", 1);
                }
                editProperties = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-delete")) {
                if (i == args2.length - 1) {
                    RecordIODriver.usage("Missing argument for option " + args2[i] + " should be a colon-spearated list of fields/subfields to delete from the records that are read", 1);
                }
                deleteSubfieldsSpec = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-convert")) {
                if (i == args2.length - 1) {
                    RecordIODriver.usage("Missing argument for option " + args2[i] + " should specify format in which to generate output", 1);
                }
                driverInfo.convert = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-matches")) {
                if (i == args2.length - 1) {
                    RecordIODriver.usage("Missing argument for option " + args2[i] + " should be field that must exist, with optional string that must be present", 1);
                }
                filterIfPresent = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-notmatches")) {
                if (i == args2.length - 1) {
                    RecordIODriver.usage("Missing argument for option " + args2[i] + " should be field that must NOT exist, with optional string that must NOT be present", 1);
                }
                filterIfMissing = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-errors")) {
                driverInfo.writeErrorRecs = true;
                driverInfo.writeNoErrorRecs = false;
                continue;
            }
            if (args2[i].equals("-raw")) {
                toUtf8 = false;
                continue;
            }
            if (args2[i].equals("-noerrors")) {
                driverInfo.writeErrorRecs = false;
                driverInfo.writeNoErrorRecs = true;
                continue;
            }
            if (args2[i].equals("-encoding")) {
                if (i == args2.length - 1) {
                    RecordIODriver.usage("Missing argument for option " + args2[i] + " should specify the expected encoding of the input file(s)", 1);
                }
                encoding = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-pretty")) {
                driverInfo.pretty = true;
                continue;
            }
            if (args2[i].equals("-split")) {
                driverInfo.splitAt = 70000;
                continue;
            }
            if (args2[i].equals("-oversize")) {
                driverInfo.oversize = true;
                continue;
            }
            if (args2[i].equals("-normalize")) {
                driverInfo.normalize = true;
                continue;
            }
            if (args2[i].equals("-strict")) {
                strict = true;
                continue;
            }
            if (args2[i].equals("-combine")) {
                if (i == args2.length - 1) {
                    RecordIODriver.usage("Missing argument for option " + args2[i] + " should specify how consecutive records with matching ids should be combined", 1);
                }
                combineConsecutiveRecordsFieldParm = args2[++i].trim();
                continue;
            }
            if (args2[i].equals("-usage")) {
                RecordIODriver.usage(null, 0);
                continue;
            }
            if (args2[i].equals("-help")) {
                RecordIODriver.usage("Missing argument for option " + args2[i] + " should specify command-line option ", 0);
                continue;
            }
            if (driverInfo.input == null && args2[i].startsWith("-") && args2[i].length() > 1) {
                RecordIODriver.usage("Unknown command line option " + args2[i], 1);
                continue;
            }
            if (driverInfo.input == null) {
                driverInfo.input = args2[i].trim();
                continue;
            }
            driverInfo.otherArgs.add(args2[i]);
        }
        driverInfo.readerConfig.setCombineConsecutiveRecordsFields(combineConsecutiveRecordsFieldParm);
        driverInfo.readerConfig.setUnicodeNormalize(driverInfo.normalize ? "C" : null);
        if (!(editProperties == null || (editFile = new File(editProperties)).exists() && editFile.canRead())) {
            System.err.println("Error: Unable to read Edit Properties file:  " + editFile.getAbsolutePath());
            System.exit(2);
        }
        driverInfo.readerConfig.setMarcRemapFilename(editProperties);
        driverInfo.readerConfig.setDeleteSubfieldSpec(deleteSubfieldsSpec);
        driverInfo.readerConfig.setDefaultEncoding(encoding);
        driverInfo.readerConfig.setFilterParams(filterIfPresent, filterIfMissing);
        driverInfo.readerConfig.setToUtf8(toUtf8);
        driverInfo.readerConfig.setPermissiveReader(!strict);
        return driverInfo;
    }

    protected static MarcWriter makeWriterFromConvertParm(RecordIODriver driverInfo, OutputStream out) {
        MarcWriter result2 = MarcWriterFactory.makeWriterFromConvertParm(driverInfo.convert, driverInfo.pretty, driverInfo.normalize, driverInfo.oversize, driverInfo.splitAt, out);
        if (result2.expectsUnicode() && !driverInfo.readerConfig.toUtf8()) {
            driverInfo.readerConfig.setToUtf8(true);
        }
        return result2;
    }

    private static void usage(String error, int exitcode) {
        if (error != null) {
            System.err.println("Error: " + error);
        }
        System.err.println("Usage: org.marc4j.util.RecordIODriver [-options] <file.mrc>");
        System.err.println("   or: org.marc4j.util.RecordIODriver [-options] <file.xml>");
        System.err.println("   or: org.marc4j.util.RecordIODriver [-options] <file.json>");
        System.err.println("       -convert <format> = Produce output in the specified format");
        System.err.println("           Valid formats are: xml, json, utf8, marc8, mrk8, ncr, text ");
        System.err.println("       -encoding <inputFile encoding> = expected character encoding of input file");
        System.err.println("       -normalize = perform Unicode normalization");
        System.err.println("       -combine = combine consecutive that have the same record id");
        System.err.println("       -errors = only output records that are flagged as containing errors");
        System.err.println("       -noerrors = only output records that are NOT flagged as containing errors");
        System.err.println("       -delete <fields> = a colon-spearated list of fields/subfields to delete from the records that are read");
        System.err.println("       -edit <file.properties> = apply all the edits specified in the file <file.properties> to the records");
        System.err.println("       -matches <pattern> = only output records that match the specified pattern");
        System.err.println("       -notmatches <pattern> = only output records that do not match the specified pattern");
        System.err.println("       -out <file> = Output to <file> instead of stdout");
        System.err.println("       -help <option> = more verbose help message about the specified option");
        System.err.println("       -usage = this message");
        System.exit(exitcode);
    }
}

