/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.marc4j.util.RawRecord;

public class RawRecordReader {
    private final DataInputStream input;
    RawRecord nextRec = null;
    RawRecord afterNextRec = null;
    boolean mergeRecords = true;

    public RawRecordReader(InputStream is) {
        this.input = new DataInputStream(new BufferedInputStream(is));
    }

    public RawRecordReader(InputStream is, boolean mergeRecords) {
        this.mergeRecords = mergeRecords;
        this.input = new DataInputStream(new BufferedInputStream(is));
    }

    public boolean hasNext() {
        if (this.nextRec == null) {
            this.nextRec = new RawRecord(this.input);
        }
        if (this.nextRec != null && this.nextRec.getRecordBytes() != null) {
            if (this.afterNextRec == null) {
                this.afterNextRec = new RawRecord(this.input);
                if (this.mergeRecords) {
                    while (this.afterNextRec != null && this.afterNextRec.getRecordBytes() != null && this.afterNextRec.getRecordId() != null && this.afterNextRec.getRecordId().equals(this.nextRec.getRecordId())) {
                        this.nextRec = new RawRecord(this.nextRec, this.afterNextRec);
                        this.afterNextRec = new RawRecord(this.input);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public RawRecord next() {
        RawRecord tmpRec = this.nextRec;
        this.nextRec = this.afterNextRec;
        this.afterNextRec = null;
        return tmpRec;
    }

    public static void main(String[] args2) {
        RawRecordReader reader = null;
        try {
            int numToSkip = 0;
            int numToOutput = -1;
            int offset = 0;
            boolean merge = true;
            boolean idsOnly = false;
            boolean unique = false;
            String idRegex = null;
            String hasFieldRegex = null;
            String idsLookedForFile = null;
            String outputfilename = null;
            while (offset >= 0 && offset < args2.length) {
                if (args2[offset].startsWith("-")) {
                    if (args2[offset].equals("-")) {
                        reader = new RawRecordReader(System.in);
                        ++offset;
                        continue;
                    }
                    if (args2[offset].equals("-skip")) {
                        if (offset == args2.length - 1) {
                            RawRecordReader.usage("Missing argument for option " + args2[offset] + " should be number of records to skip", 1);
                        }
                        numToSkip = Integer.parseInt(args2[offset + 1]);
                        offset += 2;
                        continue;
                    }
                    if (args2[offset].equals("-num")) {
                        if (offset == args2.length - 1) {
                            RawRecordReader.usage("Missing argument for option " + args2[offset] + " should be number of records to output", 1);
                        }
                        numToOutput = Integer.parseInt(args2[offset + 1]);
                        offset += 2;
                        continue;
                    }
                    if (args2[offset].equals("-nomerge")) {
                        merge = false;
                        ++offset;
                        continue;
                    }
                    if (args2[offset].equals("-id")) {
                        idsOnly = true;
                        ++offset;
                        continue;
                    }
                    if (args2[offset].equals("-u")) {
                        unique = true;
                        ++offset;
                        continue;
                    }
                    if (args2[offset].equals("-h")) {
                        if (offset == args2.length - 1) {
                            RawRecordReader.usage("Missing argument for option " + args2[offset] + " should be regex for field(s) that must be present", 1);
                        }
                        hasFieldRegex = args2[offset + 1].trim();
                        offset += 2;
                        continue;
                    }
                    if (args2[offset].equals("-o")) {
                        if (offset == args2.length - 1) {
                            RawRecordReader.usage("Missing argument for option " + args2[offset] + " should be output file name", 1);
                        }
                        outputfilename = args2[offset + 1].trim();
                        offset += 2;
                        continue;
                    }
                    if (!args2[offset].equals("-usage")) continue;
                    RawRecordReader.usage(null, 0);
                    continue;
                }
                if (args2[offset].endsWith(".mrc")) {
                    reader = new RawRecordReader(new FileInputStream(new File(args2[offset++])));
                    continue;
                }
                if (args2[offset].endsWith(".txt")) {
                    idsLookedForFile = args2[offset++];
                    continue;
                }
                idRegex = args2[offset++].trim();
            }
            FilterOutputStream out = outputfilename != null ? new BufferedOutputStream(new FileOutputStream(outputfilename)) : System.out;
            if (reader == null) {
                reader = new RawRecordReader(System.in);
            }
            reader.mergeRecords = merge;
            if (idsOnly) {
                RawRecordReader.printIds(reader, numToSkip, numToOutput);
            } else if (numToSkip != 0 || numToOutput != -1) {
                RawRecordReader.processInput(reader, numToSkip, numToOutput);
            } else if (hasFieldRegex != null) {
                RawRecordReader.processInput(reader, null, hasFieldRegex, null, out, unique);
            } else if (idRegex != null) {
                RawRecordReader.processInput(reader, idRegex, null, null, out, unique);
            } else if (idsLookedForFile != null) {
                String line;
                File idList = new File(idsLookedForFile);
                BufferedReader idStream = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(idList))));
                LinkedHashSet<String> idsLookedFor = new LinkedHashSet<String>();
                while ((line = idStream.readLine()) != null) {
                    idsLookedFor.add(line);
                }
                idStream.close();
                RawRecordReader.processInput(reader, null, null, idsLookedFor, out, unique);
            } else {
                RawRecordReader.processInput(reader, null, null, null, out, unique);
            }
        }
        catch (EOFException numToSkip) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void usage(String error, int exitcode) {
        if (error != null) {
            System.err.println("Error: " + error);
        }
        System.err.println("Usage: org.marc4j.util.RawRecordReader [-options] <file.mrc>");
        System.err.println("       -id           Output record ids only");
        System.err.println("       -h <field>    Only output records containing the specified field");
        System.err.println("       -skip <num>   Number of records to skip before outputing any");
        System.err.println("       -num <num>    Number of records to output before terminating");
        System.err.println("       -u            Only output a singles copy of a record if multiple copies of it occur in the input file.");
        System.err.println("       -o <filename> Write output to the specified file rather thatn to stdout.");
        System.err.println("       idfile.txt    Name of file containing pull-list of records to output");
        System.err.println("       id            Regex specifying id(s) of records to output");
        System.err.println("       -usage        Show this message");
        System.exit(exitcode);
    }

    private static void processInput(RawRecordReader reader, int numToSkip, int numToOutput) throws IOException {
        int num = 0;
        int numOutput = 0;
        while (reader.hasNext()) {
            RawRecord rec = reader.next();
            if (++num <= numToSkip || numToOutput != -1 && numOutput >= numToOutput) continue;
            byte[] recordBytes = rec.getRecordBytes();
            System.out.write(recordBytes);
            System.out.flush();
            ++numOutput;
        }
    }

    static void printIds(RawRecordReader reader, int numToSkip, int numToOutput) throws IOException {
        int num = 0;
        int numOutput = 0;
        while (reader.hasNext()) {
            RawRecord rec = reader.next();
            if (++num <= numToSkip || numToOutput != -1 && numOutput >= numToOutput) continue;
            String id = rec.getRecordId();
            System.out.println(id);
            ++numOutput;
        }
    }

    static void processInput(RawRecordReader reader, String idRegex, String recordHas, HashSet<String> idsLookedFor, OutputStream out, boolean unique) throws IOException {
        LinkedHashSet<String> idsOutput = new LinkedHashSet<String>();
        while (reader.hasNext()) {
            String tag;
            String field;
            RawRecord rec = reader.next();
            String id = rec.getRecordId();
            if (!((idsLookedFor != null || recordHas != null || idRegex != null && !id.matches(idRegex) || unique && idsOutput.contains(id)) && (idsLookedFor == null || !idsLookedFor.contains(id) || unique && idsOutput.contains(id)))) {
                byte[] recordBytes = rec.getRecordBytes();
                out.write(recordBytes);
                out.flush();
                idsOutput.add(id);
                continue;
            }
            if (idsLookedFor != null || idRegex != null || recordHas == null || (field = rec.getFieldVal(tag = recordHas.substring(0, 3))) == null) continue;
            byte[] recordBytes = rec.getRecordBytes();
            out.write(recordBytes);
            out.flush();
        }
    }
}

